/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import sdeditor.SDEditorException;
import sdeditor.model.SDAction;
import sdeditor.model.SDClass;
import sdeditor.model.SDDefaultProject;
import sdeditor.model.SDEvent;
import sdeditor.model.SDGuardCondition;
import sdeditor.model.SDTemplateAction;
import sdeditor.model.SDTemplateEvent;
import sdeditor.model.SDTemplateGuardCondition;
import sdeditor.util.ProgressMonitorDialogWithTitle;

public abstract class SDProject {
    private static final Logger logger;
    protected static SDProjectFactory factory;
    private static Map projects;
    private IProject project = null;
    private Map events = new LinkedHashMap();
    private Map guardConditions = new HashMap();
    private Map actions = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sdeditor.model.SDProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        factory = new SDDefaultProject.SDDefaultProjectFactory();
        projects = new HashMap();
    }

    public static SDProject getProject(IProject project) {
        if (!projects.containsKey(project)) {
            SDProject sdProject = factory.createProject();
            sdProject.setProject(project);
            sdProject.initialize();
            projects.put(project, sdProject);
        }
        return (SDProject)projects.get(project);
    }

    public static SDProject getProject(IFile file) {
        return SDProject.getProject(file.getProject());
    }

    public void initialize() {
        try {
            String title = this.getProgressMonitorTitle();
            if (title != null) {
                ProgressMonitorDialogWithTitle dialog = new ProgressMonitorDialogWithTitle(null, title);
                dialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        SDProject.this.initializeInternal(monitor);
                    }
                });
            } else {
                this.initializeInternal((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception ex) {
            throw new SDEditorException("exception caught in initializing SDProject", ex);
        }
    }

    private void initializeInternal(IProgressMonitor monitor) {
        monitor.beginTask("", 4);
        this.startInitialize((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.initializeEvents((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.initializeGuardConditions((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.initializeActions((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    private void initializeEvents(IProgressMonitor monitor) {
        List events = this.searchEventTypes(monitor);
        Iterator i = events.iterator();
        while (i.hasNext()) {
            IType type = (IType)i.next();
            this.putEvent(type.getFullyQualifiedName());
        }
    }

    private void initializeGuardConditions(IProgressMonitor monitor) {
        List guards = this.searchGuardConditionTypes(monitor);
        Iterator i = guards.iterator();
        while (i.hasNext()) {
            IType type = (IType)i.next();
            this.putGuardCondition(type.getFullyQualifiedName());
        }
    }

    private void initializeActions(IProgressMonitor monitor) {
        List actions = this.searchActionTypes(monitor);
        Iterator i = actions.iterator();
        while (i.hasNext()) {
            IType type = (IType)i.next();
            this.putAction(type.getFullyQualifiedName());
        }
    }

    public abstract String getProgressMonitorTitle();

    public abstract void startInitialize(IProgressMonitor var1);

    public abstract List searchEventTypes(IProgressMonitor var1);

    public abstract List searchGuardConditionTypes(IProgressMonitor var1);

    public abstract List searchActionTypes(IProgressMonitor var1);

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public IJavaProject getJavaProject() {
        IJavaProject myJavaProject = JavaCore.create((IProject)this.getProject());
        if (myJavaProject == null) {
            throw new SDEditorException("isn't JavaProject");
        }
        return myJavaProject;
    }

    public SDEvent getEvent(String fqcn) {
        if (!this.events.containsKey(fqcn)) {
            logger.warn((Object)("Couldn't Find Event : " + fqcn));
            this.putEvent(fqcn);
        }
        return (SDEvent)this.events.get(fqcn);
    }

    private void putEvent(String fqcn) {
        if (!this.events.containsKey(fqcn)) {
            this.events.put(fqcn, new SDTemplateEvent(new SDClass(fqcn)));
        }
    }

    public List getEvents() {
        return new ArrayList(this.events.values());
    }

    public SDGuardCondition getGuardCondition(String fqcn) {
        if (!this.guardConditions.containsKey(fqcn)) {
            logger.warn((Object)("Couldn't Find TemplateGuardCondition : " + fqcn));
            this.putGuardCondition(fqcn);
        }
        return (SDTemplateGuardCondition)this.guardConditions.get(fqcn);
    }

    private void putGuardCondition(String fqcn) {
        if (!this.guardConditions.containsKey(fqcn)) {
            this.guardConditions.put(fqcn, new SDTemplateGuardCondition(new SDClass(fqcn)));
        }
    }

    public List getGuardConditions() {
        return new ArrayList(this.guardConditions.values());
    }

    public SDAction getAction(String fqcn) {
        if (!this.actions.containsKey(fqcn)) {
            logger.warn((Object)("Couldn't Find TemplateAction : " + fqcn));
            this.putAction(fqcn);
        }
        return (SDAction)this.actions.get(fqcn);
    }

    private void putAction(String fqcn) {
        if (!this.actions.containsKey(fqcn)) {
            this.actions.put(fqcn, new SDTemplateAction(new SDClass(fqcn)));
        }
    }

    public List getActions() {
        return new ArrayList(this.actions.values());
    }

    protected static abstract class SDProjectFactory {
        protected SDProjectFactory() {
        }

        protected abstract SDProject createProject();
    }
}

