/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.serialize;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import sdeditor.SDEditorException;
import sdeditor.model.SDAction;
import sdeditor.model.SDCompositeState;
import sdeditor.model.SDElement;
import sdeditor.model.SDEvent;
import sdeditor.model.SDGuardCondition;
import sdeditor.model.SDHistoryState;
import sdeditor.model.SDInitialState;
import sdeditor.model.SDInternalAction;
import sdeditor.model.SDInternalEvent;
import sdeditor.model.SDInternalGuardCondition;
import sdeditor.model.SDRelativePoint;
import sdeditor.model.SDRootStateMachine;
import sdeditor.model.SDState;
import sdeditor.model.SDStateMachine;
import sdeditor.model.SDTemplateAction;
import sdeditor.model.SDTemplateEvent;
import sdeditor.model.SDTemplateGuardCondition;
import sdeditor.model.SDTerminalState;
import sdeditor.model.SDTransition;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.IStateDiagramFactory;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.XAction;
import sdeditor.model.xml.XCompositeState;
import sdeditor.model.xml.XEvent;
import sdeditor.model.xml.XGuardCondition;
import sdeditor.model.xml.XPoint;
import sdeditor.model.xml.XRelativePoint;
import sdeditor.model.xml.XRootStateMachine;
import sdeditor.model.xml.XSize;
import sdeditor.model.xml.XSpecialState;
import sdeditor.model.xml.XState;
import sdeditor.model.xml.XStateMachine;
import sdeditor.model.xml.XTransition;
import sdeditor.model.xml.XTransitionLabel;
import trier.util.EIdMap;

public class SDXMLOutput {
    private IStateDiagramFactory factory = null;
    private EIdMap idMap = null;
    private XRootStateMachine root = null;
    private Set transitions = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sdeditor.model.serialize.SDXMLOutput");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private void initialize() {
        this.factory = StateDiagramFactory.getFactory();
        this.idMap = new EIdMap();
        this.root = this.createEmptyXRootStateMachine();
        this.transitions = new LinkedHashSet();
    }

    public synchronized XRootStateMachine process(SDRootStateMachine sdRoot) {
        this.initialize();
        this.root.setStateMachine(this.createXStateMachine(sdRoot));
        this.processTransitions();
        return this.root;
    }

    private void processTransitions() {
        Iterator i = this.transitions.iterator();
        while (i.hasNext()) {
            SDTransition transition = (SDTransition)i.next();
            this.createXTransition(transition);
        }
    }

    private IRNode createXElement(SDElement sdElement) {
        if (sdElement == null) {
            return null;
        }
        if (sdElement instanceof SDCompositeState) {
            return this.createXCompositeState((SDCompositeState)sdElement);
        }
        if (sdElement instanceof SDState) {
            return this.createXSpecialState((SDState)sdElement);
        }
        if (sdElement instanceof SDTransition) {
            return this.createXTransition((SDTransition)sdElement);
        }
        if (sdElement instanceof SDEvent) {
            return this.createXEvent((SDEvent)sdElement);
        }
        if (sdElement instanceof SDGuardCondition) {
            return this.createXGuardCondition((SDGuardCondition)sdElement);
        }
        if (sdElement instanceof SDAction) {
            return this.createXAction((SDAction)sdElement);
        }
        throw new SDEditorException("illegal element for XML");
    }

    private List createXElements(List sdElements) {
        ArrayList<IRNode> xElements = new ArrayList<IRNode>();
        Iterator i = sdElements.iterator();
        while (i.hasNext()) {
            xElements.add(this.createXElement((SDElement)i.next()));
        }
        return xElements;
    }

    private String getId(SDElement sdElement) {
        if (sdElement == SDTransition.defaultEvent) {
            return "AUTO";
        }
        if (sdElement == SDTransition.defaultGuardCondition) {
            return "EVERY";
        }
        if (!this.idMap.containtsKey((Object)sdElement)) {
            this.createXElement(sdElement);
        }
        if (!$assertionsDisabled && !this.idMap.containtsKey((Object)sdElement)) {
            throw new AssertionError();
        }
        return this.idMap.getId((Object)sdElement);
    }

    private String[] getIds(List sdElements) {
        int len = sdElements.size();
        String[] ids = new String[len];
        int i = 0;
        while (i < len) {
            ids[i] = this.getId((SDElement)sdElements.get(i));
            ++i;
        }
        return ids;
    }

    private XRootStateMachine createEmptyXRootStateMachine() {
        XRootStateMachine xRoot = this.factory.createXRootStateMachine();
        xRoot.setEvents(this.factory.createXEvents());
        xRoot.setGuardConditions(this.factory.createXGuardConditions());
        xRoot.setActions(this.factory.createXActions());
        xRoot.setTransitions(this.factory.createXTransitions());
        return xRoot;
    }

    private XStateMachine createXStateMachine(SDStateMachine sdStateMachine) {
        SDCompositeState sdState;
        SDHistoryState sdHState;
        XStateMachine xStateMachine = this.factory.createXStateMachine();
        xStateMachine.setCompositeStates(this.factory.createXCompositeStates());
        xStateMachine.setTerminalStates(this.factory.createXTerminalStates());
        xStateMachine.setInitialState(this.factory.createXInitialState());
        xStateMachine.setHistoryState(this.factory.createXHistoryState());
        List xStateList = this.createXElements(sdStateMachine.getStates());
        XCompositeState[] xStateArray = new XCompositeState[xStateList.size()];
        xStateMachine.getCompositeStates().setCompositeState(xStateList.toArray(xStateArray));
        if (sdStateMachine.getInitialState() != null) {
            xStateMachine.getInitialState().setSpecialState(this.createXSpecialState(sdStateMachine.getInitialState()));
        }
        List xFinalStateList = this.createXElements(sdStateMachine.getTerminalStates());
        XSpecialState[] xFinalStateArray = new XSpecialState[xFinalStateList.size()];
        xStateMachine.getTerminalStates().setSpecialState(xFinalStateList.toArray(xFinalStateArray));
        if (!(sdStateMachine instanceof SDRootStateMachine) && (sdHState = (sdState = (SDCompositeState)sdStateMachine).getHistoryState()) != null) {
            xStateMachine.getHistoryState().setSpecialState(this.createXSpecialState(sdHState));
        }
        return xStateMachine;
    }

    private XState createXState(SDState sdState) {
        XState xState = this.factory.createXState();
        this.transitions.addAll(sdState.getSourceTransitions());
        String id = this.idMap.putObject((Object)sdState);
        xState.setId(id);
        xState.setPoint(this.createXPoint(sdState.getLocation()));
        xState.setSize(this.createXSize(sdState.getSize()));
        xState.setEntryActions(this.getIds(sdState.getEntryActions()));
        xState.setDoActions(this.getIds(sdState.getDoActions()));
        xState.setExitActions(this.getIds(sdState.getExitActions()));
        return xState;
    }

    private XCompositeState createXCompositeState(SDCompositeState sdState) {
        XCompositeState xCompositeState = this.factory.createXCompositeState();
        xCompositeState.setName(sdState.getName());
        xCompositeState.setState(this.createXState(sdState));
        xCompositeState.setStateMachine(this.createXStateMachine(sdState));
        return xCompositeState;
    }

    private XSpecialState createXSpecialState(SDState sdSpecialState) {
        XSpecialState xSpecialState = this.factory.createXSpecialState();
        if (sdSpecialState instanceof SDInitialState) {
            xSpecialState.setType("INITIALSTATE");
        } else if (sdSpecialState instanceof SDTerminalState) {
            xSpecialState.setType("TERMINALSTATE");
        } else if (sdSpecialState instanceof SDHistoryState) {
            xSpecialState.setType("HISTORYSTATE");
        } else {
            throw new SDEditorException("Illegal State Type for XML");
        }
        xSpecialState.setState(this.createXState(sdSpecialState));
        return xSpecialState;
    }

    private XTransition createXTransition(SDTransition sdTransition) {
        XTransition xTransition = this.factory.createXTransition();
        xTransition.setBendpoints(this.factory.createXBendpoints());
        this.root.getTransitions().addTransition(xTransition);
        String sourceId = this.idMap.getId((Object)sdTransition.getSourceState());
        xTransition.setSource(sourceId);
        String targetId = this.idMap.getId((Object)sdTransition.getTargetState());
        xTransition.setTarget(targetId);
        xTransition.setEvent(this.getId(sdTransition.getEvent()));
        xTransition.setGuardCondition(this.getId(sdTransition.getGuardCondition()));
        xTransition.setActions(this.getIds(sdTransition.getActions()));
        Iterator i = sdTransition.getBendpoints().iterator();
        while (i.hasNext()) {
            xTransition.getBendpoints().addRelativePoint(this.createXRelativePoint((SDRelativePoint)i.next()));
        }
        XTransitionLabel label = this.factory.createXTransitionLabel();
        label.setRelativePoint(this.createXRelativePoint(sdTransition.getLabel().getLocation()));
        xTransition.setTransitionLabel(label);
        return xTransition;
    }

    private XEvent createXEvent(SDEvent sdEvent) {
        String key = this.idMap.putObject((Object)sdEvent);
        XEvent xEvent = this.factory.createXEvent();
        xEvent.setId(key);
        this.root.getEvents().addEvent(xEvent);
        if (sdEvent instanceof SDInternalEvent) {
            xEvent.setType("INTERNAL");
            xEvent.setName(sdEvent.getName());
        } else if (sdEvent instanceof SDTemplateEvent) {
            xEvent.setType("TEMPLATE");
            xEvent.setName(((SDTemplateEvent)sdEvent).getType().getFQCN());
        } else {
            throw new SDEditorException("Illegal Event type for XML");
        }
        return xEvent;
    }

    private XGuardCondition createXGuardCondition(SDGuardCondition sdGuardCondition) {
        String key = this.idMap.putObject((Object)sdGuardCondition);
        XGuardCondition xGuardCondition = this.factory.createXGuardCondition();
        xGuardCondition.setId(key);
        this.root.getGuardConditions().addGuardCondition(xGuardCondition);
        if (sdGuardCondition instanceof SDInternalGuardCondition) {
            xGuardCondition.setType("INTERNAL");
            xGuardCondition.setName(sdGuardCondition.getName());
        } else if (sdGuardCondition instanceof SDTemplateGuardCondition) {
            xGuardCondition.setType("TEMPLATE");
            xGuardCondition.setName(((SDTemplateGuardCondition)sdGuardCondition).getType().getFQCN());
        } else {
            throw new SDEditorException("Illegal GuardCondition Type for XML");
        }
        return xGuardCondition;
    }

    private XAction createXAction(SDAction sdAction) {
        String key = this.idMap.putObject((Object)sdAction);
        XAction xAction = this.factory.createXAction();
        xAction.setId(key);
        this.root.getActions().addAction(xAction);
        if (sdAction instanceof SDInternalAction) {
            xAction.setType("INTERNAL");
            xAction.setName(sdAction.getName());
        } else if (sdAction instanceof SDTemplateAction) {
            xAction.setType("TEMPLATE");
            xAction.setName(((SDTemplateAction)sdAction).getType().getFQCN());
        } else {
            throw new SDEditorException("Illegal Action Type for XML");
        }
        return xAction;
    }

    private XPoint createXPoint(Point point) {
        XPoint xPoint = this.factory.createXPoint();
        xPoint.setX(point.x);
        xPoint.setY(point.y);
        return xPoint;
    }

    private XSize createXSize(Dimension d) {
        XSize xSize = this.factory.createXSize();
        xSize.setWidth(d.width);
        xSize.setHeight(d.height);
        return xSize;
    }

    private XRelativePoint createXRelativePoint(SDRelativePoint point) {
        XRelativePoint xPoint = this.factory.createXRelativePoint();
        XSize x1 = this.createXSize(point.getD1());
        XSize x2 = this.createXSize(point.getD2());
        xPoint.setSize1(x1);
        xPoint.setSize2(x2);
        xPoint.setWeight(point.getWeight());
        return xPoint;
    }
}

