/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.serialize;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import sdeditor.model.SDDocument;
import sdeditor.model.serialize.SDDocumentSerializer;
import sdeditor.model.serialize.SDXMLInput;
import sdeditor.model.serialize.SDXMLOutput;
import sdeditor.model.xml.IStateDiagramFactory;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.URelaxer;
import sdeditor.model.xml.XRootStateMachine;

public class SDXMLSerializer
extends SDDocumentSerializer {
    public static final String INITIALSTATE = "INITIALSTATE";
    public static final String TERMINALSTATE = "TERMINALSTATE";
    public static final String HISTORYSTATE = "HISTORYSTATE";
    public static final String DEFAULT_EVENT_TYPE = "AUTO";
    public static final String DEFAULT_GUARDCONDITION = "EVERY";
    public static final String INTERNAL = "INTERNAL";
    public static final String TEMPLATE = "TEMPLATE";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sdeditor.model.serialize.SDXMLSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SDDocumentSerializer.serializerClass = clazz;
    }

    public void serialize(SDDocument document, OutputStream output) throws Exception {
        SDXMLOutput xOut = new SDXMLOutput();
        XRootStateMachine xRoot = xOut.process(document.getRootStateMachine());
        OutputStreamWriter ow = new OutputStreamWriter(output, "UTF-8");
        String print = URelaxer.doc2String4Print(xRoot.makeDocument(), "UTF-8");
        ow.write(print);
        ow.flush();
    }

    public SDDocument unSerialize(InputStream input) throws Exception {
        IStateDiagramFactory factory = StateDiagramFactory.getFactory();
        XRootStateMachine root = factory.createXRootStateMachine();
        root.setup(input);
        SDXMLInput xIn = new SDXMLInput(this.getProject());
        SDDocument doc = xIn.process(root);
        return doc;
    }
}

