/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import sdeditor.model.xml.RStack;

public final class URelaxer {
    private static char[] map__ = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static Object autoIDHandler__ = null;
    private static String autoIDPrefix__ = null;
    private static Boolean autoIDThreadSingle__ = null;
    private static Boolean autoIDThreadGroupSingle__ = null;

    public static String getString(String value) {
        return value;
    }

    public static String getString(String[] value) {
        if (value == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        if (value.length > 0) {
            buffer.append(value[0]);
            int i = 1;
            while (i < value.length) {
                buffer.append(" ");
                buffer.append(value[i]);
                ++i;
            }
        }
        return new String(buffer);
    }

    public static String[] getStringList(String value) {
        StringTokenizer st = new StringTokenizer(value);
        String[] list = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            list[i++] = st.nextToken();
        }
        return list;
    }

    public static List makeStringList(String string) {
        ArrayList<String> list = new ArrayList<String>();
        if (string != null) {
            StringTokenizer st = new StringTokenizer(string);
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return list;
    }

    public static String escape(String string) {
        if (string.indexOf(60) == -1 && string.indexOf(62) == -1 && string.indexOf(38) == -1 && string.indexOf(34) == -1 && string.indexOf(39) == -1) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        int size = string.length();
        int i = 0;
        while (i < size) {
            char c = string.charAt(i);
            if (c == '<') {
                buffer.append("&lt;");
            } else if (c == '>') {
                buffer.append("&gt;");
            } else if (c == '&') {
                buffer.append("&amp;");
            } else if (c == '\"') {
                buffer.append("&quot;");
            } else if (c == '\'') {
                buffer.append("&apos;");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return new String(buffer);
    }

    public static String escapeEntityQuot(String string) {
        if (string.indexOf(37) == -1 && string.indexOf(38) == -1 && string.indexOf(34) == -1) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        int size = string.length();
        int i = 0;
        while (i < size) {
            char c = string.charAt(i);
            if (c == '%') {
                buffer.append("&---;");
            } else if (c == '&') {
                buffer.append("&amp;");
            } else if (c == '\"') {
                buffer.append("&quot;");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return new String(buffer);
    }

    public static String escapeEntityApos(String string) {
        if (string.indexOf(37) == -1 && string.indexOf(38) == -1 && string.indexOf(39) == -1) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        int size = string.length();
        int i = 0;
        while (i < size) {
            char c = string.charAt(i);
            if (c == '%') {
                buffer.append("&#x25;");
            } else if (c == '&') {
                buffer.append("&amp;");
            } else if (c == '\'') {
                buffer.append("&apos;");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return new String(buffer);
    }

    public static String escapeAttrQuot(String string) {
        if (string.indexOf(60) == -1 && string.indexOf(38) == -1 && string.indexOf(34) == -1) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        int size = string.length();
        int i = 0;
        while (i < size) {
            char c = string.charAt(i);
            if (c == '<') {
                buffer.append("&lt;");
            } else if (c == '&') {
                buffer.append("&amp;");
            } else if (c == '\"') {
                buffer.append("&quot;");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return new String(buffer);
    }

    public static String escapeAttrApos(String string) {
        if (string.indexOf(60) == -1 && string.indexOf(38) == -1 && string.indexOf(39) == -1) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        int size = string.length();
        int i = 0;
        while (i < size) {
            char c = string.charAt(i);
            if (c == '<') {
                buffer.append("&lt;");
            } else if (c == '&') {
                buffer.append("&amp;");
            } else if (c == '\'') {
                buffer.append("&apos;");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return new String(buffer);
    }

    public static String escapeSystemQuot(String string) {
        if (string.indexOf(34) == -1) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        int size = string.length();
        int i = 0;
        while (i < size) {
            char c = string.charAt(i);
            if (c == '\"') {
                buffer.append("&quot;");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return new String(buffer);
    }

    public static String escapeSystemApos(String string) {
        if (string.indexOf(39) == -1) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        int size = string.length();
        int i = 0;
        while (i < size) {
            char c = string.charAt(i);
            if (c == '\'') {
                buffer.append("&apos;");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return new String(buffer);
    }

    public static String escapeCharData(String string) {
        if (string.indexOf(60) == -1 && string.indexOf(38) == -1 && string.indexOf(">") == -1) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        int size = string.length();
        int i = 0;
        while (i < size) {
            char c = string.charAt(i);
            if (c == '<') {
                buffer.append("&lt;");
            } else if (c == '&') {
                buffer.append("&amp;");
            } else if (c == '>') {
                buffer.append("&gt;");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return new String(buffer);
    }

    public static String getElementPropertyAsString(Element element) {
        return URelaxer.element2Text(element);
    }

    public static List getElementPropertyAsStringList(Element element) {
        return URelaxer.makeStringList(URelaxer.element2Text(element));
    }

    public static String getElementPropertyAsString(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Text(property);
        return text;
    }

    public static List getElementPropertyAsStringList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < nodes.length) {
            list.add(URelaxer.element2Text(nodes[i]));
            ++i;
        }
        return list;
    }

    public static String getElementPropertyAsStringByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return URelaxer.element2Text(property);
    }

    public static List getElementPropertyAsStringListByStack(RStack stack, String name) {
        Element property;
        ArrayList<String> list = new ArrayList<String>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(URelaxer.element2Text(property));
        }
        return list;
    }

    public static String getAttributePropertyAsString(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return value;
    }

    public static List getAttributePropertyAsStringList(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        return URelaxer.makeStringList(value);
    }

    public static void setElementPropertyByString(Element element, String name, String value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(value);
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByString(Element element, String value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(value);
        element.appendChild(text);
    }

    public static void setElementPropertyByStringList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setAttributePropertyByString(Element element, String name, String value) {
        if (value == null || "".equals(value)) {
            if (URelaxer.getAttribute(element, name) != null) {
                element.removeAttribute(name);
            }
        } else {
            element.setAttribute(name, value);
        }
    }

    public static void setAttributePropertyByStringList(Element element, String name, List values) {
        StringBuffer buffer = new StringBuffer();
        int size = values.size();
        if (size > 0) {
            buffer.append(values.get(0).toString());
            int i = 1;
            while (i < size) {
                buffer.append(" ");
                buffer.append(values.get(i).toString());
                ++i;
            }
        }
        element.setAttribute(name, new String(buffer));
    }

    public static String getString(boolean value) {
        if (value) {
            return "true";
        }
        return "false";
    }

    public static String getString(Boolean value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static boolean getBooleanValue(Object value) {
        if (value instanceof Boolean) {
            Boolean object = (Boolean)value;
            return object;
        }
        return "true".equals(value.toString());
    }

    public static boolean getElementPropertyAsBoolean(Element element) {
        String text = URelaxer.element2Data(element);
        return "true".equals(text);
    }

    public static boolean getElementPropertyAsBoolean(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        return URelaxer.getElementPropertyAsBoolean(property);
    }

    public static List getElementPropertyAsBooleanList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        int i = 0;
        while (i < nodes.length) {
            list.add(new Boolean(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static Boolean getElementPropertyAsBooleanByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return new Boolean(URelaxer.element2Data(property));
    }

    public static List getElementPropertyAsBooleanListByStack(RStack stack, String name) {
        Element property;
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(new Boolean(URelaxer.element2Text(property)));
        }
        return list;
    }

    public static boolean getAttributePropertyAsBoolean(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return false;
        }
        return "true".equals(value);
    }

    public static Boolean getAttributePropertyAsBooleanObject(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return new Boolean(value);
    }

    public static void setElementPropertyByBoolean(Element element, String name, boolean value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(URelaxer.getString(value));
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByBoolean(Element element, String name, Boolean value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(value.toString());
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByBooleanList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyByBoolean(Element element, boolean value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(URelaxer.getString(value));
        element.appendChild(text);
    }

    public static void setAttributePropertyByBoolean(Element element, String name, boolean value) {
        element.setAttribute(name, URelaxer.getString(value));
    }

    public static void setAttributePropertyByBoolean(Element element, String name, Boolean value) {
        element.setAttribute(name, value.toString());
    }

    public static String getString(byte value) {
        return Byte.toString(value);
    }

    public static String getString(Byte value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static byte getByteValue(Object value) {
        Number object = value instanceof Number ? (Number)((Number)value) : (Number)new Byte(value.toString());
        return object.byteValue();
    }

    public static byte getElementPropertyAsByte(Element element) {
        String text = URelaxer.element2Data(element);
        return Byte.parseByte(text);
    }

    public static byte getElementPropertyAsByte(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return Byte.parseByte(text);
    }

    public static List getElementPropertyAsByteList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<Byte> list = new ArrayList<Byte>();
        int i = 0;
        while (i < nodes.length) {
            list.add(new Byte(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static Byte getElementPropertyAsByteByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return new Byte(URelaxer.element2Data(property));
    }

    public static List getElementPropertyAsByteListByStack(RStack stack, String name) {
        Element property;
        ArrayList<Byte> list = new ArrayList<Byte>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(new Byte(URelaxer.element2Text(property)));
        }
        return list;
    }

    public static byte getAttributePropertyAsByte(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return 0;
        }
        return Byte.parseByte(value);
    }

    public static Byte getAttributePropertyAsByteObject(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return new Byte(value);
    }

    public static void setElementPropertyByByte(Element element, String name, byte value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(Byte.toString(value));
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByByte(Element element, String name, Byte value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(value.toString());
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByByteList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyByByte(Element element, byte value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(Byte.toString(value));
        element.appendChild(text);
    }

    public static void setAttributePropertyByByte(Element element, String name, byte value) {
        element.setAttribute(name, Byte.toString(value));
    }

    public static void setAttributePropertyByByte(Element element, String name, Byte value) {
        element.setAttribute(name, value.toString());
    }

    public static String getString(short value) {
        return Short.toString(value);
    }

    public static String getString(Short value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static short getShortValue(Object value) {
        Number object = value instanceof Number ? (Number)((Number)value) : (Number)new Short(value.toString());
        return object.shortValue();
    }

    public static short getElementPropertyAsShort(Element element) {
        String text = URelaxer.element2Data(element);
        return Short.parseShort(text);
    }

    public static short getElementPropertyAsShort(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return Short.parseShort(text);
    }

    public static List getElementPropertyAsShortList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<Short> list = new ArrayList<Short>();
        int i = 0;
        while (i < nodes.length) {
            list.add(new Short(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static Short getElementPropertyAsShortByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return new Short(URelaxer.element2Data(property));
    }

    public static List getElementPropertyAsShortListByStack(RStack stack, String name) {
        Element property;
        ArrayList<Short> list = new ArrayList<Short>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(new Short(URelaxer.element2Text(property)));
        }
        return list;
    }

    public static short getAttributePropertyAsShort(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return 0;
        }
        return Short.parseShort(value);
    }

    public static Short getAttributePropertyAsShortObject(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return new Short(value);
    }

    public static void setElementPropertyByShort(Element element, String name, short value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(Short.toString(value));
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByShort(Element element, String name, Short value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(value.toString());
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByShortList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyByShort(Element element, short value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(Short.toString(value));
        element.appendChild(text);
    }

    public static void setAttributePropertyByShort(Element element, String name, short value) {
        element.setAttribute(name, Short.toString(value));
    }

    public static void setAttributePropertyByShort(Element element, String name, Short value) {
        element.setAttribute(name, value.toString());
    }

    public static String getString(int value) {
        return Integer.toString(value);
    }

    public static String getString(Integer value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static int getIntValue(Object value) {
        Number object = value instanceof Number ? (Number)((Number)value) : (Number)new Integer(value.toString());
        return object.intValue();
    }

    public static int getElementPropertyAsInt(Element element) {
        String text = URelaxer.element2Data(element);
        return Integer.parseInt(text);
    }

    public static int getElementPropertyAsInt(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return Integer.parseInt(text);
    }

    public static List getElementPropertyAsIntList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < nodes.length) {
            list.add(new Integer(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static Integer getElementPropertyAsIntByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return new Integer(URelaxer.element2Data(property));
    }

    public static List getElementPropertyAsIntListByStack(RStack stack, String name) {
        Element property;
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(new Integer(URelaxer.element2Text(property)));
        }
        return list;
    }

    public static int getAttributePropertyAsInt(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public static Integer getAttributePropertyAsIntObject(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return new Integer(value);
    }

    public static void setElementPropertyByInt(Element element, String name, int value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(Integer.toString(value));
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByInt(Element element, String name, Integer value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(value.toString());
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByIntList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyByInt(Element element, int value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(Integer.toString(value));
        element.appendChild(text);
    }

    public static void setAttributePropertyByInt(Element element, String name, int value) {
        element.setAttribute(name, Integer.toString(value));
    }

    public static void setAttributePropertyByInt(Element element, String name, Integer value) {
        element.setAttribute(name, value.toString());
    }

    public static String getString(long value) {
        return Long.toString(value);
    }

    public static String getString(Long value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static long getLongValue(Object value) {
        Number object = value instanceof Number ? (Number)((Number)value) : (Number)new Long(value.toString());
        return object.byteValue();
    }

    public static long getElementPropertyAsLong(Element element) {
        String text = URelaxer.element2Data(element);
        return Long.parseLong(text);
    }

    public static long getElementPropertyAsLong(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return Long.parseLong(text);
    }

    public static List getElementPropertyAsLongList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<Long> list = new ArrayList<Long>();
        int i = 0;
        while (i < nodes.length) {
            list.add(new Long(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static Long getElementPropertyAsLongByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return new Long(URelaxer.element2Data(property));
    }

    public static List getElementPropertyAsLongListByStack(RStack stack, String name) {
        Element property;
        ArrayList<Long> list = new ArrayList<Long>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(new Long(URelaxer.element2Text(property)));
        }
        return list;
    }

    public static long getAttributePropertyAsLong(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return 0L;
        }
        return Long.parseLong(value);
    }

    public static Long getAttributePropertyAsLongObject(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return new Long(value);
    }

    public static void setElementPropertyByLong(Element element, String name, long value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(Long.toString(value));
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByLong(Element element, String name, Long value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(value.toString());
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByLongList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyByLong(Element element, long value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(Long.toString(value));
        element.appendChild(text);
    }

    public static void setAttributePropertyByLong(Element element, String name, long value) {
        element.setAttribute(name, Long.toString(value));
    }

    public static void setAttributePropertyByLong(Element element, String name, Long value) {
        element.setAttribute(name, value.toString());
    }

    public static String getString(float value) {
        return Float.toString(value);
    }

    public static String getString(Float value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static float getFloatValue(Object value) {
        Number object = value instanceof Number ? (Number)((Number)value) : (Number)new Float(value.toString());
        return object.floatValue();
    }

    public static float getElementPropertyAsFloat(Element element) {
        String text = URelaxer.element2Data(element);
        return Float.parseFloat(text);
    }

    public static float getElementPropertyAsFloat(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return Float.parseFloat(text);
    }

    public static List getElementPropertyAsFloatList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<Float> list = new ArrayList<Float>();
        int i = 0;
        while (i < nodes.length) {
            list.add(new Float(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static Float getElementPropertyAsFloatByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return new Float(URelaxer.element2Data(property));
    }

    public static List getElementPropertyAsFloatListByStack(RStack stack, String name) {
        Element property;
        ArrayList<Float> list = new ArrayList<Float>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(new Float(URelaxer.element2Text(property)));
        }
        return list;
    }

    public static float getAttributePropertyAsFloat(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return 0.0f;
        }
        return Float.parseFloat(value);
    }

    public static Float getAttributePropertyAsFloatObject(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return new Float(value);
    }

    public static void setElementPropertyByFloat(Element element, String name, float value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(Float.toString(value));
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByFloat(Element element, String name, Float value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(value.toString());
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByFloatList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyByFloat(Element element, float value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(Float.toString(value));
        element.appendChild(text);
    }

    public static void setAttributePropertyByFloat(Element element, String name, float value) {
        element.setAttribute(name, Float.toString(value));
    }

    public static void setAttributePropertyByFloat(Element element, String name, Float value) {
        element.setAttribute(name, value.toString());
    }

    public static String getString(double value) {
        return Double.toString(value);
    }

    public static String getString(Double value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static double getDoubleValue(Object value) {
        Number object = value instanceof Number ? (Number)((Number)value) : (Number)new Double(value.toString());
        return object.doubleValue();
    }

    public static double getElementPropertyAsDouble(Element element) {
        String text = URelaxer.element2Data(element);
        return Double.parseDouble(text);
    }

    public static double getElementPropertyAsDouble(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return Double.parseDouble(text);
    }

    public static List getElementPropertyAsDoubleList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<Double> list = new ArrayList<Double>();
        int i = 0;
        while (i < nodes.length) {
            list.add(new Double(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static Double getElementPropertyAsDoubleByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return new Double(URelaxer.element2Data(property));
    }

    public static List getElementPropertyAsDoubleListByStack(RStack stack, String name) {
        Element property;
        ArrayList<Double> list = new ArrayList<Double>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(new Double(URelaxer.element2Text(property)));
        }
        return list;
    }

    public static double getAttributePropertyAsDouble(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    public static Double getAttributePropertyAsDoubleObject(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return new Double(value);
    }

    public static void setElementPropertyByDouble(Element element, String name, double value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(Double.toString(value));
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByDouble(Element element, String name, Double value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(value.toString());
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByDoubleList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyByDouble(Element element, double value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(Double.toString(value));
        element.appendChild(text);
    }

    public static void setAttributePropertyByDouble(Element element, String name, double value) {
        element.setAttribute(name, Double.toString(value));
    }

    public static void setAttributePropertyByDouble(Element element, String name, Double value) {
        element.setAttribute(name, value.toString());
    }

    public static String getString(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static BigDecimal getBigDecimalObject(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    public static BigDecimal getElementPropertyAsBigDecimal(Element element) {
        String text = URelaxer.element2Data(element);
        return new BigDecimal(text);
    }

    public static BigDecimal getElementPropertyAsBigDecimal(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return new BigDecimal(text);
    }

    public static List getElementPropertyAsBigDecimalList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        int i = 0;
        while (i < nodes.length) {
            list.add(new BigDecimal(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static BigDecimal getElementPropertyAsBigDecimalByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return URelaxer.getElementPropertyAsBigDecimal(property);
    }

    public static List getElementPropertyAsBigDecimalListByStack(RStack stack, String name) {
        Element property;
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(new BigDecimal(URelaxer.element2Text(property)));
        }
        return list;
    }

    public static BigDecimal getAttributePropertyAsBigDecimal(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static void setElementPropertyByBigDecimal(Element element, String name, BigDecimal value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(value.toString());
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByBigDecimalList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyByBigDecimal(Element element, BigDecimal value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(value.toString());
        element.appendChild(text);
    }

    public static void setAttributePropertyByBigDecimal(Element element, String name, BigDecimal value) {
        if (value != null) {
            element.setAttribute(name, value.toString());
        }
    }

    public static String getString(BigInteger value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static BigInteger getBigIntegerObject(Object value) {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        return new BigInteger(value.toString());
    }

    public static BigInteger getElementPropertyAsBigInteger(Element element) {
        String text = URelaxer.element2Data(element);
        return new BigInteger(text);
    }

    public static BigInteger getElementPropertyAsBigInteger(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return new BigInteger(text);
    }

    public static List getElementPropertyAsBigIntegerList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<BigInteger> list = new ArrayList<BigInteger>();
        int i = 0;
        while (i < nodes.length) {
            list.add(new BigInteger(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static BigInteger getElementPropertyAsBigIntegerByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return URelaxer.getElementPropertyAsBigInteger(property);
    }

    public static List getElementPropertyAsBigIntegerListByStack(RStack stack, String name) {
        Element property;
        ArrayList<BigInteger> list = new ArrayList<BigInteger>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(new BigInteger(URelaxer.element2Text(property)));
        }
        return list;
    }

    public static BigInteger getAttributePropertyAsBigInteger(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return new BigInteger(value);
    }

    public static void setElementPropertyByBigInteger(Element element, String name, BigInteger value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(value.toString());
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByBigIntegerList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyByBigInteger(Element element, BigInteger value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(value.toString());
        element.appendChild(text);
    }

    public static void setAttributePropertyByBigInteger(Element element, String name, BigInteger value) {
        if (value != null) {
            element.setAttribute(name, value.toString());
        }
    }

    public static String getString(java.util.Date value) {
        if (value == null) {
            return null;
        }
        return URelaxer.getString(new Timestamp(value.getTime()));
    }

    public static java.util.Date getDateObject(Object value) {
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        return URelaxer.getSQLTimestampObject(value);
    }

    public static java.util.Date getElementPropertyAsDate(Element element) {
        try {
            String text = URelaxer.element2Data(element);
            DateFormat df = DateFormat.getDateInstance();
            return df.parse(text);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static java.util.Date getElementPropertyAsDate(Element element, String name) {
        try {
            Element property = URelaxer.getOnlyElement(element, name);
            String text = URelaxer.element2Data(property);
            DateFormat df = DateFormat.getDateInstance();
            return df.parse(text);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static List getElementPropertyAsDateList(Element element, String name) {
        try {
            Element[] nodes = URelaxer.getElements(element, name);
            DateFormat df = DateFormat.getDateInstance();
            ArrayList<java.util.Date> list = new ArrayList<java.util.Date>();
            int i = 0;
            while (i < nodes.length) {
                list.add(df.parse(URelaxer.element2Data(nodes[i])));
                ++i;
            }
            return list;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static java.util.Date getElementPropertyAsDateByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return URelaxer.getElementPropertyAsDate(property);
    }

    public static List getElementPropertyAsDateListByStack(RStack stack, String name) {
        Element property;
        ArrayList<java.util.Date> list = new ArrayList<java.util.Date>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            String value = URelaxer.element2Text(property);
            try {
                DateFormat df = DateFormat.getDateInstance();
                list.add(df.parse(value));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return list;
    }

    public static java.util.Date getAttributePropertyAsDate(Element element, String name) {
        try {
            String value = URelaxer.getAttribute(element, name);
            if (value == null) {
                return null;
            }
            DateFormat df = DateFormat.getDateInstance();
            return df.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static void setElementPropertyByDate(Element element, String name, java.util.Date value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        DateFormat df = DateFormat.getDateInstance();
        Text text = doc.createTextNode(df.format(value));
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByDateList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyByDate(Element element, java.util.Date value) {
        Document doc = element.getOwnerDocument();
        DateFormat df = DateFormat.getDateInstance();
        Text text = doc.createTextNode(df.format(value));
        element.appendChild(text);
    }

    public static void setAttributePropertyByDate(Element element, String name, java.util.Date value) {
        if (value != null) {
            DateFormat df = DateFormat.getDateInstance();
            element.setAttribute(name, df.format(value));
        }
    }

    public static String getString(Locale value) {
        return value.toString();
    }

    public static Locale getLocale(String value) {
        if (value == null) {
            return null;
        }
        return URelaxer.makeLocale(value);
    }

    public static Locale getLocaleObject(Object value) {
        if (value instanceof Locale) {
            return (Locale)value;
        }
        return URelaxer.makeLocale(value.toString());
    }

    public static Locale getElementPropertyAsLocale(Element element) {
        String text = URelaxer.element2Data(element);
        return URelaxer.makeLocale(text);
    }

    public static Locale getElementPropertyAsLocale(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return URelaxer.makeLocale(text);
    }

    public static List getElementPropertyAsLocaleList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<Locale> list = new ArrayList<Locale>();
        int i = 0;
        while (i < nodes.length) {
            list.add(URelaxer.makeLocale(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static Locale getElementPropertyAsLocaleByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return URelaxer.getElementPropertyAsLocale(property);
    }

    public static List getElementPropertyAsLocaleListByStack(RStack stack, String name) {
        Element property;
        ArrayList<Locale> list = new ArrayList<Locale>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(URelaxer.makeLocale(URelaxer.element2Text(property)));
        }
        return list;
    }

    public static Locale getAttributePropertyAsLocale(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return URelaxer.makeLocale(value);
    }

    public static void setElementPropertyByLocale(Element element, String name, Locale value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(value.toString());
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByLocaleList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyByLocale(Element element, Locale value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(value.toString());
        element.appendChild(text);
    }

    public static void setAttributePropertyByLocale(Element element, String name, Locale value) {
        if (value != null) {
            element.setAttribute(name, value.toString());
        }
    }

    public static String getString(URL value) {
        if (value == null) {
            return null;
        }
        return value.toExternalForm();
    }

    public static URL getURL(String value) {
        return URelaxer.makeURL(value);
    }

    public static URL getURLObject(Object value) {
        if (value instanceof URL) {
            return (URL)value;
        }
        return URelaxer.makeURL(value.toString());
    }

    public static URL getElementPropertyAsURL(Element element) {
        String text = URelaxer.element2Data(element);
        return URelaxer.makeURL(text);
    }

    public static URL getElementPropertyAsURL(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return URelaxer.makeURL(text);
    }

    public static List getElementPropertyAsURLList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<URL> list = new ArrayList<URL>();
        int i = 0;
        while (i < nodes.length) {
            list.add(URelaxer.makeURL(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static URL getElementPropertyAsURLByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return URelaxer.getElementPropertyAsURL(property);
    }

    public static List getElementPropertyAsURLListByStack(RStack stack, String name) {
        Element property;
        ArrayList<URL> list = new ArrayList<URL>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(URelaxer.makeURL(URelaxer.element2Text(property)));
        }
        return list;
    }

    public static URL getAttributePropertyAsURL(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return URelaxer.makeURL(value);
    }

    public static void setElementPropertyByURL(Element element, String name, URL value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(value.toString());
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByURLList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyByURL(Element element, URL value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(value.toString());
        element.appendChild(text);
    }

    public static void setAttributePropertyByURL(Element element, String name, URL value) {
        if (value != null) {
            element.setAttribute(name, value.toString());
        }
    }

    public static String getString(Timestamp value) {
        if (value == null) {
            return null;
        }
        return value.toString().replace(' ', 'T');
    }

    public static Timestamp getSQLTimestamp(String value) {
        return Timestamp.valueOf(value.trim().replace('T', ' '));
    }

    public static Timestamp getSQLTimestampObject(Object value) {
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        return URelaxer.getSQLTimestamp(value.toString());
    }

    public static Timestamp getElementPropertyAsSQLTimestamp(Element element) {
        String text = URelaxer.element2Data(element);
        return URelaxer.getSQLTimestamp(text);
    }

    public static Timestamp getElementPropertyAsSQLTimestamp(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return URelaxer.getSQLTimestamp(text);
    }

    public static List getElementPropertyAsSQLTimestampList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<Timestamp> list = new ArrayList<Timestamp>();
        int i = 0;
        while (i < nodes.length) {
            list.add(URelaxer.getSQLTimestamp(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static Timestamp getElementPropertyAsSQLTimestampByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return URelaxer.getElementPropertyAsSQLTimestamp(property);
    }

    public static List getElementPropertyAsSQLTimestampListByStack(RStack stack, String name) {
        Element property;
        ArrayList<Timestamp> list = new ArrayList<Timestamp>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(URelaxer.getSQLTimestamp(URelaxer.element2Text(property)));
        }
        return list;
    }

    public static Timestamp getAttributePropertyAsSQLTimestamp(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return URelaxer.getSQLTimestamp(value);
    }

    public static void setElementPropertyBySQLTimestamp(Element element, String name, Timestamp value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(URelaxer.getString(value));
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyBySQLTimestampList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(URelaxer.getString((Timestamp)values.get(i)));
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyBySQLTimestamp(Element element, Timestamp value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(URelaxer.getString(value));
        element.appendChild(text);
    }

    public static void setAttributePropertyBySQLTimestamp(Element element, String name, Timestamp value) {
        if (value != null) {
            element.setAttribute(name, URelaxer.getString(value));
        }
    }

    public static String getString(Time value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static Time getSQLTime(String value) {
        return Time.valueOf(value);
    }

    public static Time getSQLTimeObject(Object value) {
        if (value instanceof Time) {
            return (Time)value;
        }
        return URelaxer.getSQLTime(value.toString());
    }

    public static Time getElementPropertyAsSQLTime(Element element) {
        String text = URelaxer.element2Data(element);
        return URelaxer.getSQLTime(text);
    }

    public static Time getElementPropertyAsSQLTime(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return URelaxer.getSQLTime(text);
    }

    public static List getElementPropertyAsSQLTimeList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<Time> list = new ArrayList<Time>();
        int i = 0;
        while (i < nodes.length) {
            list.add(URelaxer.getSQLTime(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static Time getElementPropertyAsSQLTimeByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return URelaxer.getElementPropertyAsSQLTime(property);
    }

    public static List getElementPropertyAsSQLTimeListByStack(RStack stack, String name) {
        Element property;
        ArrayList<Time> list = new ArrayList<Time>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(URelaxer.getSQLTime(URelaxer.element2Text(property)));
        }
        return list;
    }

    public static Time getAttributePropertyAsSQLTime(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return URelaxer.getSQLTime(value);
    }

    public static void setElementPropertyBySQLTime(Element element, String name, Time value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(value.toString());
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyBySQLTimeList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyBySQLTime(Element element, Time value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(value.toString());
        element.appendChild(text);
    }

    public static void setAttributePropertyBySQLTime(Element element, String name, Time value) {
        if (value != null) {
            element.setAttribute(name, value.toString());
        }
    }

    public static String getString(Date value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static Date getSQLDate(String value) {
        return Date.valueOf(value);
    }

    public static Date getSQLDateObject(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        return URelaxer.getSQLDate(value.toString());
    }

    public static Date getElementPropertyAsSQLDate(Element element) {
        String text = URelaxer.element2Data(element);
        return URelaxer.getSQLDate(text);
    }

    public static Date getElementPropertyAsSQLDate(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return URelaxer.getSQLDate(text);
    }

    public static List getElementPropertyAsSQLDateList(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<Date> list = new ArrayList<Date>();
        int i = 0;
        while (i < nodes.length) {
            list.add(URelaxer.getSQLDate(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static Date getElementPropertyAsSQLDateByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return URelaxer.getElementPropertyAsSQLDate(property);
    }

    public static List getElementPropertyAsSQLDateListByStack(RStack stack, String name) {
        Element property;
        ArrayList<Date> list = new ArrayList<Date>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(URelaxer.getSQLDate(URelaxer.element2Text(property)));
        }
        return list;
    }

    public static Date getAttributePropertyAsSQLDate(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        if (value == null) {
            return null;
        }
        return URelaxer.getSQLDate(value);
    }

    public static void setElementPropertyBySQLDate(Element element, String name, Date value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(value.toString());
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyBySQLDateList(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(values.get(i).toString());
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyBySQLDate(Element element, Date value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(value.toString());
        element.appendChild(text);
    }

    public static void setAttributePropertyBySQLDate(Element element, String name, Date value) {
        if (value != null) {
            element.setAttribute(name, value.toString());
        }
    }

    public static String getString(byte[] value) {
        if (value == null) {
            return null;
        }
        return URelaxer.makeStringAsBASE64(value);
    }

    public static byte[] getBinary(String value) {
        return URelaxer.makeBytesByBASE64(value);
    }

    public static byte[] getBinaryObject(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        return URelaxer.getBinary(value.toString());
    }

    public static byte[] getElementPropertyAsBinaryBASE64(Element element) {
        String text = URelaxer.element2Data(element);
        return URelaxer.makeBytesByBASE64(text);
    }

    public static byte[] getElementPropertyAsBinaryBASE64(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return URelaxer.makeBytesByBASE64(text);
    }

    public static List getElementPropertyAsBinaryListBASE64(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int i = 0;
        while (i < nodes.length) {
            list.add(URelaxer.makeBytesByBASE64(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static byte[] getElementPropertyAsBinaryBASE64ByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return URelaxer.getElementPropertyAsBinaryBASE64(property);
    }

    public static List getElementPropertyAsBinaryListBASE64ByStack(RStack stack, String name) {
        Element property;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(URelaxer.getElementPropertyAsBinaryBASE64(property));
        }
        return list;
    }

    public static void setElementPropertyByBinaryBASE64(Element element, String name, byte[] value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(URelaxer.makeStringAsBASE64(value));
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByBinaryListBASE64(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(URelaxer.makeStringAsBASE64((byte[])values.get(i)));
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyByBinaryBASE64(Element element, byte[] value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(URelaxer.makeStringAsBASE64(value));
        element.appendChild(text);
    }

    public static String getStringByBinaryHEX(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return URelaxer.makeStringAsHEX(bytes);
    }

    public static byte[] getBinaryHEXObject(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        return URelaxer.makeBytesByHEX(value.toString());
    }

    public static byte[] getElementPropertyAsBinaryHEX(Element element) {
        String text = URelaxer.element2Data(element);
        return URelaxer.makeBytesByHEX(text);
    }

    public static byte[] getElementPropertyAsBinaryHEX(Element element, String name) {
        Element property = URelaxer.getOnlyElement(element, name);
        String text = URelaxer.element2Data(property);
        return URelaxer.makeBytesByHEX(text);
    }

    public static List getElementPropertyAsBinaryListHEX(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int i = 0;
        while (i < nodes.length) {
            list.add(URelaxer.makeBytesByHEX(URelaxer.element2Data(nodes[i])));
            ++i;
        }
        return list;
    }

    public static byte[] getElementPropertyAsBinaryHEXByStack(RStack stack, String name) {
        if (stack.isEmptyElement()) {
            return null;
        }
        Element property = stack.peekElement();
        if (!name.equals(property.getTagName())) {
            return null;
        }
        stack.popElement();
        return URelaxer.getElementPropertyAsBinaryHEX(property);
    }

    public static List getElementPropertyAsBinaryListHEXByStack(RStack stack, String name) {
        Element property;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        while (!stack.isEmptyElement() && name.equals((property = stack.peekElement()).getTagName())) {
            stack.popElement();
            list.add(URelaxer.getElementPropertyAsBinaryHEX(property));
        }
        return list;
    }

    public static void setElementPropertyByBinaryHEX(Element element, String name, byte[] value) {
        Document doc = element.getOwnerDocument();
        Element property = doc.createElement(name);
        Text text = doc.createTextNode(URelaxer.makeStringAsHEX(value));
        property.appendChild(text);
        element.appendChild(property);
    }

    public static void setElementPropertyByBinaryListHEX(Element element, String name, List values) {
        Document doc = element.getOwnerDocument();
        int size = values.size();
        int i = 0;
        while (i < size) {
            Element property = doc.createElement(name);
            Text text = doc.createTextNode(URelaxer.makeStringAsHEX((byte[])values.get(i)));
            property.appendChild(text);
            element.appendChild(property);
            ++i;
        }
    }

    public static void setElementPropertyByBinaryHEX(Element element, byte[] value) {
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(URelaxer.makeStringAsHEX(value));
        element.appendChild(text);
    }

    public static String getString(Object object) {
        return object.toString();
    }

    public static boolean isTargetElement(Element element, String localName) {
        return localName.equals(element.getTagName());
    }

    public static boolean hasAttribute(Element element, String name) {
        String value = URelaxer.getAttribute(element, name);
        return value != null;
    }

    public static String getAttribute(Element element, String name) {
        Attr attr = element.getAttributeNode(name);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static boolean isSequence(RStack stack, String name) {
        Element[] elements = stack.peekElements();
        if (elements == null) {
            return false;
        }
        if (elements.length != 1) {
            return false;
        }
        return name.equals(elements[0].getTagName());
    }

    public static boolean isSequence(RStack stack, String[] names) {
        Element[] elements = stack.peekElements();
        if (elements == null) {
            return false;
        }
        if (elements.length != names.length) {
            return false;
        }
        int i = 0;
        while (i < names.length) {
            if (!names[i].equals(elements[i].getTagName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean hasElement(Element element, String name) {
        Element[] nodes = URelaxer.getElements(element, name);
        return nodes.length > 0;
    }

    public static boolean hasElement(Element element, String[] names) {
        Element[] elements = URelaxer.getElements(element);
        int i = 0;
        while (i < elements.length) {
            int j = 0;
            while (j < names.length) {
                if (names[j].equals(elements[i].getTagName())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static Element getOnlyElement(Element element, String name) throws IllegalArgumentException {
        Element[] nodes = URelaxer.getElements(element, name);
        switch (nodes.length) {
            case 0: {
                return null;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return nodes[0];
    }

    public static Element[] getElements(Element element) {
        NodeList children = element.getChildNodes();
        ArrayList<Node> list = new ArrayList<Node>();
        int size = children.getLength();
        int i = 0;
        while (i < size) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                list.add(child);
            }
            ++i;
        }
        Element[] array = new Element[list.size()];
        return list.toArray(array);
    }

    public static Element[] getElements(Element element, String name) {
        NodeList children = element.getChildNodes();
        ArrayList<Element> list = new ArrayList<Element>();
        int size = children.getLength();
        int i = 0;
        while (i < size) {
            Element childElement;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && name.equals((childElement = (Element)child).getTagName())) {
                list.add(childElement);
            }
            ++i;
        }
        Element[] array = new Element[list.size()];
        return list.toArray(array);
    }

    public static Stack getElementsAsStack(Element element) {
        NodeList children = element.getChildNodes();
        Stack<Node> stack = new Stack<Node>();
        int size = children.getLength();
        int i = size - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                stack.push(children.item(i));
            }
            --i;
        }
        return stack;
    }

    public static String getStringByMixedList(List list) {
        StringBuffer buffer = new StringBuffer();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object object = list.get(i);
            if (object.getClass().getName().endsWith("RString")) {
                buffer.append(object.toString());
            }
            ++i;
        }
        return new String(buffer);
    }

    public static String getQName(String prefix, String localName) {
        if (prefix == null) {
            return localName;
        }
        if ("".equals(prefix)) {
            return localName;
        }
        return String.valueOf(prefix) + ":" + localName;
    }

    public static void makeQName(String prefix, String localName, StringBuffer buffer) {
        if (prefix == null) {
            buffer.append(localName);
        } else if ("".equals(prefix)) {
            buffer.append(localName);
        } else {
            buffer.append(prefix);
            buffer.append(":");
            buffer.append(localName);
        }
    }

    public static void makeQName(String prefix, String localName, PrintWriter buffer) {
        if (prefix == null) {
            buffer.print(localName);
        } else if ("".equals(prefix)) {
            buffer.print(localName);
        } else {
            buffer.print(prefix);
            buffer.print(":");
            buffer.print(localName);
        }
    }

    public static String getNSMapping(String prefix, String uri) {
        if (prefix == null) {
            return "";
        }
        if ("".equals(prefix)) {
            return " xmlns=\"" + uri + "\"";
        }
        return " xmlns:" + prefix + "=\"" + uri + "\"";
    }

    public static String element2Data(Element element) {
        return URelaxer.element2Text(element).trim();
    }

    public static String element2Text(Element element) {
        return URelaxer.node2Text(element);
    }

    public static String nodes2Text(Node[] nodes) {
        StringBuffer buffer = new StringBuffer();
        int nNodes = nodes.length;
        int i = 0;
        while (i < nNodes) {
            URelaxer.node2Text(nodes[i], buffer);
            ++i;
        }
        return new String(buffer);
    }

    public static String node2Text(Node node) {
        StringBuffer buffer = new StringBuffer();
        URelaxer.node2Text(node, buffer);
        return new String(buffer);
    }

    public static void node2Text(Node node, StringBuffer buffer) {
        switch (node.getNodeType()) {
            case 1: 
            case 9: {
                URelaxer._nodeChildren2Text(node, buffer);
                break;
            }
            case 5: {
                EntityReference eref = (EntityReference)node;
                String erefName = eref.getNodeName();
                if ("lt".equals(erefName)) {
                    buffer.append("<");
                    break;
                }
                if ("gt".equals(erefName)) {
                    buffer.append(">");
                    break;
                }
                if ("amp".equals(erefName)) {
                    buffer.append("&");
                    break;
                }
                if ("quot".equals(erefName)) {
                    buffer.append("'");
                    break;
                }
                if ("apos".equals(erefName)) {
                    buffer.append("\"");
                    break;
                }
                URelaxer._nodeChildren2Text(eref, buffer);
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("not supported yet");
            }
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                Text text = (Text)node;
                buffer.append(text.getData());
                break;
            }
            default: {
                throw new UnsupportedOperationException("not supported yet");
            }
        }
    }

    private static void _nodeChildren2Text(Node node, StringBuffer buffer) {
        NodeList nodes = node.getChildNodes();
        int nNodes = nodes.getLength();
        int i = 0;
        while (i < nNodes) {
            URelaxer.node2Text(nodes.item(i), buffer);
            ++i;
        }
    }

    public static Locale makeLocale(String name) {
        name = name.replace('-', '_');
        StringTokenizer st = new StringTokenizer(name, "_");
        switch (st.countTokens()) {
            case 1: {
                return new Locale(st.nextToken(), "", "");
            }
            case 2: {
                return new Locale(st.nextToken(), st.nextToken(), "");
            }
            case 3: {
                return new Locale(st.nextToken(), st.nextToken(), st.nextToken());
            }
        }
        return null;
    }

    public static URL makeURL(String name) {
        try {
            return new URL(name);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL makeURL(URL base, URL leaf) {
        if (leaf.getProtocol() != null) {
            return leaf;
        }
        try {
            return new URL(base, leaf.toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String makeStringJava(java.util.Date date) {
        DateFormat df = DateFormat.getDateInstance();
        return df.format(date);
    }

    public static java.util.Date makeDateJava(String cdata) throws ParseException {
        DateFormat df = DateFormat.getDateInstance();
        return df.parse(cdata);
    }

    public static String makeStringAsBASE64(byte[] bytes) {
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        int i = 0;
        while (i < bytes.length) {
            int data4;
            int data3;
            int data2;
            int data1 = (bytes[i] & 0xFC) >> 2;
            if (i + 1 >= bytes.length) {
                data2 = (bytes[i] & 3) << 4;
                data3 = -1;
                data4 = -1;
            } else {
                data2 = (bytes[i] & 3) << 4 | (bytes[i + 1] & 0xF0) >> 4;
                if (i + 2 >= bytes.length) {
                    data3 = (bytes[i + 1] & 0xF) << 2;
                    data4 = -1;
                } else {
                    data3 = (bytes[i + 1] & 0xF) << 2 | (bytes[i + 2] & 0xC0) >> 6;
                    data4 = bytes[i + 2] & 0x3F;
                }
            }
            buffer.append(map__[data1]);
            buffer.append(map__[data2]);
            if (data3 == -1) {
                buffer.append("=");
            } else {
                buffer.append(map__[data3]);
            }
            if (data4 == -1) {
                buffer.append("=");
            } else {
                buffer.append(map__[data4]);
            }
            if ((count += 4) >= 76) {
                buffer.append("\n");
                count = 0;
            }
            i += 3;
        }
        return new String(buffer);
    }

    public static byte[] makeBytesByBASE64(String cdata) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int status = 0;
        int byteData = 0;
        int size = cdata.length();
        int i = 0;
        while (i < size) {
            char charData = cdata.charAt(i);
            int newData = URelaxer._calcData(charData);
            if (charData == '=') break;
            if (newData != -1) {
                switch (status) {
                    case 0: {
                        byteData = newData << 2;
                        status = 1;
                        break;
                    }
                    case 1: {
                        buffer.write(byteData |= (newData & 0x30) >> 4);
                        byteData = (newData & 0xF) << 4;
                        status = 2;
                        break;
                    }
                    case 2: {
                        buffer.write(byteData |= (newData & 0x3C) >> 2);
                        byteData = (newData & 3) << 6;
                        status = 3;
                        break;
                    }
                    case 3: {
                        buffer.write(byteData |= newData);
                        status = 0;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            ++i;
        }
        return buffer.toByteArray();
    }

    private static int _calcData(int charData) {
        if (65 <= charData && charData <= 90) {
            return charData - 65;
        }
        if (97 <= charData && charData <= 122) {
            return charData - 97 + 26;
        }
        if (48 <= charData && charData <= 57) {
            return charData - 48 + 26 + 26;
        }
        if (charData == 43) {
            return 62;
        }
        if (charData == 47) {
            return 63;
        }
        return -1;
    }

    public static String makeStringAsHEX(byte[] bytes) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            switch (bytes[i] & 0xF0) {
                case 0: {
                    buffer.append("0");
                    break;
                }
                case 16: {
                    buffer.append("1");
                    break;
                }
                case 32: {
                    buffer.append("2");
                    break;
                }
                case 48: {
                    buffer.append("3");
                    break;
                }
                case 64: {
                    buffer.append("4");
                    break;
                }
                case 80: {
                    buffer.append("5");
                    break;
                }
                case 96: {
                    buffer.append("6");
                    break;
                }
                case 112: {
                    buffer.append("7");
                    break;
                }
                case 128: {
                    buffer.append("8");
                    break;
                }
                case 144: {
                    buffer.append("9");
                    break;
                }
                case 160: {
                    buffer.append("A");
                    break;
                }
                case 176: {
                    buffer.append("B");
                    break;
                }
                case 192: {
                    buffer.append("C");
                    break;
                }
                case 208: {
                    buffer.append("D");
                    break;
                }
                case 224: {
                    buffer.append("E");
                    break;
                }
                case 240: {
                    buffer.append("F");
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            switch (bytes[i] & 0xF) {
                case 0: {
                    buffer.append("0");
                    break;
                }
                case 1: {
                    buffer.append("1");
                    break;
                }
                case 2: {
                    buffer.append("2");
                    break;
                }
                case 3: {
                    buffer.append("3");
                    break;
                }
                case 4: {
                    buffer.append("4");
                    break;
                }
                case 5: {
                    buffer.append("5");
                    break;
                }
                case 6: {
                    buffer.append("6");
                    break;
                }
                case 7: {
                    buffer.append("7");
                    break;
                }
                case 8: {
                    buffer.append("8");
                    break;
                }
                case 9: {
                    buffer.append("9");
                    break;
                }
                case 10: {
                    buffer.append("A");
                    break;
                }
                case 11: {
                    buffer.append("B");
                    break;
                }
                case 12: {
                    buffer.append("C");
                    break;
                }
                case 13: {
                    buffer.append("D");
                    break;
                }
                case 14: {
                    buffer.append("E");
                    break;
                }
                case 15: {
                    buffer.append("F");
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ++i;
        }
        return new String(buffer);
    }

    public static byte[] makeBytesByHEX(String cdata) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int size = cdata.length();
            int i = 0;
            while (i < size) {
                int byteData;
                switch (cdata.charAt(i)) {
                    case '0': {
                        byteData = 0;
                        break;
                    }
                    case '1': {
                        byteData = 16;
                        break;
                    }
                    case '2': {
                        byteData = 32;
                        break;
                    }
                    case '3': {
                        byteData = 48;
                        break;
                    }
                    case '4': {
                        byteData = 64;
                        break;
                    }
                    case '5': {
                        byteData = 80;
                        break;
                    }
                    case '6': {
                        byteData = 96;
                        break;
                    }
                    case '7': {
                        byteData = 112;
                        break;
                    }
                    case '8': {
                        byteData = -128;
                        break;
                    }
                    case '9': {
                        byteData = -112;
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        byteData = -96;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        byteData = -80;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        byteData = -64;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        byteData = -48;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        byteData = -32;
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        byteData = -16;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                switch (cdata.charAt(i + 1)) {
                    case '0': {
                        byteData = (byte)(byteData | 0);
                        break;
                    }
                    case '1': {
                        byteData = (byte)(byteData | 1);
                        break;
                    }
                    case '2': {
                        byteData = (byte)(byteData | 2);
                        break;
                    }
                    case '3': {
                        byteData = (byte)(byteData | 3);
                        break;
                    }
                    case '4': {
                        byteData = (byte)(byteData | 4);
                        break;
                    }
                    case '5': {
                        byteData = (byte)(byteData | 5);
                        break;
                    }
                    case '6': {
                        byteData = (byte)(byteData | 6);
                        break;
                    }
                    case '7': {
                        byteData = (byte)(byteData | 7);
                        break;
                    }
                    case '8': {
                        byteData = (byte)(byteData | 8);
                        break;
                    }
                    case '9': {
                        byteData = (byte)(byteData | 9);
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        byteData = (byte)(byteData | 0xA);
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        byteData = (byte)(byteData | 0xB);
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        byteData = (byte)(byteData | 0xC);
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        byteData = (byte)(byteData | 0xD);
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        byteData = (byte)(byteData | 0xE);
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        byteData = (byte)(byteData | 0xF);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                buffer.write(byteData);
                i += 2;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
        return buffer.toByteArray();
    }

    public static void setAutoIDHandler(Object handler) {
        autoIDHandler__ = handler;
    }

    public static void setAutoIDPrefix(String prefix) {
        autoIDPrefix__ = prefix;
    }

    public static String getAutoIDPrefix() {
        return autoIDPrefix__;
    }

    public static void setAutoIDThreadSingle(Boolean threadSingle) {
        autoIDThreadSingle__ = threadSingle;
    }

    public static Boolean getAutoIDThreadSingle() {
        return autoIDThreadSingle__;
    }

    public static void setAutoIDThreadGroupSingle(Boolean threadGroupSingle) {
        autoIDThreadGroupSingle__ = threadGroupSingle;
    }

    public static Boolean getAutoIDThreadGroupSingle() {
        return autoIDThreadGroupSingle__;
    }

    public static String makeAutoID() {
        if (autoIDHandler__ != null) {
            return autoIDHandler__.toString();
        }
        return URelaxer._makeDefaultAutoID();
    }

    private static String _makeDefaultAutoID() {
        String prefix = URelaxer._getAutoIDPrefix();
        StringBuffer buffer = new StringBuffer();
        if (prefix != null) {
            buffer.append(prefix);
        }
        buffer.append(Long.toHexString(System.currentTimeMillis()));
        if (!URelaxer._isAutoIDSingleThread()) {
            Thread thread = Thread.currentThread();
            buffer.append("00");
            URelaxer._hashAppend(thread.getName(), buffer);
            if (!URelaxer._isAutoIDSingleThreadGroup()) {
                buffer.append("00");
                URelaxer._hashAppend(thread.getThreadGroup().getName(), buffer);
            }
        }
        return new String(buffer);
    }

    private static void _hashAppend(String string, StringBuffer buffer) {
        int size = string.length();
        int i = 0;
        while (i < size) {
            char c = string.charAt(i);
            buffer.append(Integer.toHexString(c));
            ++i;
        }
    }

    private static String _getAutoIDPrefix() {
        String prefix = URelaxer.getAutoIDPrefix();
        if (prefix != null) {
            return prefix;
        }
        return URelaxer._getPropertyPrefix();
    }

    private static boolean _isAutoIDSingleThread() {
        Boolean value = URelaxer.getAutoIDThreadSingle();
        if (value != null) {
            return value;
        }
        return URelaxer._isPropertySingleThread();
    }

    private static boolean _isAutoIDSingleThreadGroup() {
        Boolean value = URelaxer.getAutoIDThreadGroupSingle();
        if (value != null) {
            return value;
        }
        return URelaxer._isPropertySingleThreadGroup();
    }

    private static String _getPropertyPrefix() {
        return System.getProperty("org.relaxer.autoid.prefix");
    }

    private static boolean _isPropertySingleThread() {
        return "true".equals(System.getProperty("org.relaxer.autoid.thread.single"));
    }

    private static boolean _isPropertySingleThreadGroup() {
        return "true".equals(System.getProperty("org.relaxer.autoid.threadGroup.single"));
    }

    public static Timestamp makeAutoSQLTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Time makeAutoSQLTime() {
        return new Time(System.currentTimeMillis());
    }

    public static Date makeAutoSQLDate() {
        return new Date(System.currentTimeMillis());
    }

    public static Object getPropertyObject(String value) {
        return value;
    }

    public static Object getPropertyObject(boolean value) {
        return new Boolean(value);
    }

    public static Object getPropertyObject(byte value) {
        return new Byte(value);
    }

    public static Object getPropertyObject(short value) {
        return new Short(value);
    }

    public static Object getPropertyObject(int value) {
        return new Integer(value);
    }

    public static Object getPropertyObject(long value) {
        return new Long(value);
    }

    public static Object getPropertyObject(float value) {
        return new Float(value);
    }

    public static Object getPropertyObject(double value) {
        return new Double(value);
    }

    public static Object getPropertyObject(Object value) {
        return value;
    }

    public static Object getPropertyObject(Collection value) {
        return value.toArray();
    }

    public static String doc2String4Print(Document doc) {
        StringBuffer buffer = new StringBuffer();
        Element element = doc.getDocumentElement();
        buffer.append("<?xml version='1.0' ?>\n");
        URelaxer._node2String4Print(element, "", buffer);
        return new String(buffer);
    }

    public static String doc2String4Print(Document doc, String encoding) {
        StringBuffer buffer = new StringBuffer();
        Element element = doc.getDocumentElement();
        buffer.append("<?xml version='1.0' encoding='");
        buffer.append(encoding);
        buffer.append("' ?>\n");
        URelaxer._node2String4Print(element, "", buffer);
        return new String(buffer);
    }

    public static String node2String4Print(Node node, String encoding) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version='1.0' encoding='");
        buffer.append(encoding);
        buffer.append("' ?>\n");
        URelaxer._node2String4Print(node, "", buffer);
        return new String(buffer);
    }

    public static String node2String4Print(Node node) {
        return URelaxer._node2String4Print(node, "");
    }

    protected static String _node2String4Print(Node node, String indent) {
        StringBuffer buffer = new StringBuffer();
        URelaxer._node2String4Print(node, indent, buffer);
        return new String(buffer);
    }

    protected static void _node2String4Print(Node node, String indent, StringBuffer buffer) {
        switch (node.getNodeType()) {
            case 1: {
                Element element = (Element)node;
                String tag = element.getTagName();
                buffer.append(indent);
                buffer.append("<");
                buffer.append(tag);
                NamedNodeMap attrs = element.getAttributes();
                int nAttrs = attrs.getLength();
                int i = 0;
                while (i < nAttrs) {
                    Attr attr = (Attr)attrs.item(i);
                    buffer.append(' ');
                    buffer.append(attr.getName());
                    buffer.append("=\"");
                    buffer.append(attr.getValue());
                    buffer.append('\"');
                    ++i;
                }
                buffer.append(">");
                boolean needIndent = URelaxer.hasChildElement(element);
                if (needIndent) {
                    buffer.append("\n");
                }
                NodeList nodes = element.getChildNodes();
                int nNodes = nodes.getLength();
                int i2 = 0;
                while (i2 < nNodes) {
                    Node child = nodes.item(i2);
                    if (child.getNodeType() == 3) {
                        Text text = (Text)child;
                        if (!URelaxer.isBlankText(text)) {
                            buffer.append(text.getData());
                        }
                    } else {
                        URelaxer._node2String4Print(child, String.valueOf(indent) + "  ", buffer);
                    }
                    ++i2;
                }
                if (needIndent) {
                    buffer.append(indent);
                }
                buffer.append("</" + tag + ">\n");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("not supported yet");
            }
            case 3: {
                Text text = (Text)node;
                buffer.append(text.getData());
                break;
            }
            case 4: {
                throw new UnsupportedOperationException("not supported yet");
            }
            case 5: {
                throw new UnsupportedOperationException("not supported yet");
            }
            case 7: {
                throw new UnsupportedOperationException("not supported yet");
            }
            case 8: {
                throw new UnsupportedOperationException("not supported yet");
            }
            case 9: {
                NodeList nodes = node.getChildNodes();
                int nNodes = nodes.getLength();
                int i = 0;
                while (i < nNodes) {
                    URelaxer._node2String4Print(nodes.item(i), indent, buffer);
                    ++i;
                }
                break;
            }
            case 10: {
                throw new UnsupportedOperationException("not supported yet");
            }
            case 11: {
                throw new UnsupportedOperationException("not supported yet");
            }
            case 12: {
                throw new UnsupportedOperationException("not supported yet");
            }
            default: {
                throw new UnsupportedOperationException("not supported yet");
            }
        }
    }

    public static String doc2String4Data(Document doc) {
        StringBuffer buffer = new StringBuffer();
        Element element = doc.getDocumentElement();
        buffer.append("<?xml version='1.0' ?>");
        URelaxer._node2String4Data(element, buffer);
        return new String(buffer);
    }

    public static String node2String4Data(Node node) {
        StringBuffer buffer = new StringBuffer();
        URelaxer._node2String4Data(node, buffer);
        return new String(buffer);
    }

    private static void _node2String4Data(Node node, StringBuffer buffer) {
        switch (node.getNodeType()) {
            case 9: {
                throw new UnsupportedOperationException("not supported yet");
            }
            case 1: {
                Element element = (Element)node;
                String tag = element.getTagName();
                buffer.append('<');
                buffer.append(tag);
                NamedNodeMap attrs = element.getAttributes();
                int size = attrs.getLength();
                int i = 0;
                while (i < size) {
                    Attr attr = (Attr)attrs.item(i);
                    buffer.append(' ');
                    buffer.append(attr.getName());
                    buffer.append("=\"");
                    buffer.append(attr.getValue());
                    buffer.append('\"');
                    ++i;
                }
                buffer.append('>');
                NodeList nodes = element.getChildNodes();
                int nNodes = nodes.getLength();
                int i2 = 0;
                while (i2 < nNodes) {
                    URelaxer._node2String4Data(nodes.item(i2), buffer);
                    ++i2;
                }
                buffer.append("</");
                buffer.append(tag);
                buffer.append('>');
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("not supported yet");
            }
            case 8: {
                throw new UnsupportedOperationException("not supported yet");
            }
            case 3: 
            case 4: {
                Text text = (Text)node;
                buffer.append(text.getData());
                break;
            }
            default: {
                throw new UnsupportedOperationException("not supported yet");
            }
        }
    }

    public static boolean hasChildElement(Element element) {
        NodeList nodes = element.getChildNodes();
        int nNodes = nodes.getLength();
        int i = 0;
        while (i < nNodes) {
            if (nodes.item(i).getNodeType() == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isBlankText(Text text) {
        String data = text.getData();
        char[] chars = data.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!URelaxer.isSpace(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }
}

