/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.IStateDiagramFactory;
import sdeditor.model.xml.RStack;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.UJAXP;
import sdeditor.model.xml.URelaxer;
import sdeditor.model.xml.XState;
import sdeditor.model.xml.XStateMachine;

public class XCompositeState
implements Serializable,
IRNode {
    private String name_;
    private XState state_;
    private XStateMachine stateMachine_;
    private IRNode parentRNode_;

    public XCompositeState() {
    }

    public XCompositeState(RStack stack) {
        this.setup(stack);
    }

    public XCompositeState(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XCompositeState(Element element) {
        this.setup(element);
    }

    public XCompositeState(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XCompositeState(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XCompositeState(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XCompositeState(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XCompositeState(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XCompositeState(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        IStateDiagramFactory factory = StateDiagramFactory.getFactory();
        RStack stack = new RStack(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.setState(factory.createXState(stack));
        this.setStateMachine(factory.createXStateMachine(stack));
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("compositeState");
        URelaxer.setAttributePropertyByString(element, "name", this.name_);
        this.state_.makeElement(element);
        this.stateMachine_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final XState getState() {
        return this.state_;
    }

    public final void setState(XState state) {
        this.state_ = state;
        if (state != null) {
            state.setParentRNode(this);
        }
    }

    public final XStateMachine getStateMachine() {
        return this.stateMachine_;
    }

    public final void setStateMachine(XStateMachine stateMachine) {
        this.stateMachine_ = stateMachine;
        if (stateMachine != null) {
            stateMachine.setParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<compositeState");
        buffer.append(" name=\"");
        buffer.append(URelaxer.escapeAttrQuot(this.getName()));
        buffer.append("\"");
        buffer.append(">");
        this.state_.makeTextElement(buffer);
        this.stateMachine_.makeTextElement(buffer);
        buffer.append("</compositeState>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<compositeState");
        buffer.print(" name=\"");
        buffer.print(URelaxer.escapeAttrQuot(this.getName()));
        buffer.print("\"");
        buffer.print(">");
        this.state_.makeTextElement(buffer);
        this.stateMachine_.makeTextElement(buffer);
        buffer.print("</compositeState>");
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode getParentRNode() {
        return this.parentRNode_;
    }

    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] getRNodes() {
        ArrayList<Serializable> classNodes = new ArrayList<Serializable>();
        classNodes.add(this.state_);
        classNodes.add(this.stateMachine_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "compositeState")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!XState.isMatchHungry(target)) {
            return false;
        }
        if (!XStateMachine.isMatchHungry(target)) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XCompositeState.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XCompositeState.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

