/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.IStateDiagramFactory;
import sdeditor.model.xml.RStack;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.UJAXP;
import sdeditor.model.xml.URelaxer;
import sdeditor.model.xml.XSpecialState;

public class XHistoryState
implements Serializable,
IRNode {
    private XSpecialState specialState_;
    private IRNode parentRNode_;

    public XHistoryState() {
    }

    public XHistoryState(RStack stack) {
        this.setup(stack);
    }

    public XHistoryState(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XHistoryState(Element element) {
        this.setup(element);
    }

    public XHistoryState(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XHistoryState(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XHistoryState(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XHistoryState(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XHistoryState(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XHistoryState(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        IStateDiagramFactory factory = StateDiagramFactory.getFactory();
        RStack stack = new RStack(element);
        if (XSpecialState.isMatch(stack)) {
            this.setSpecialState(factory.createXSpecialState(stack));
        }
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("historyState");
        if (this.specialState_ != null) {
            this.specialState_.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final XSpecialState getSpecialState() {
        return this.specialState_;
    }

    public final void setSpecialState(XSpecialState specialState) {
        this.specialState_ = specialState;
        if (specialState != null) {
            specialState.setParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<historyState");
        buffer.append(">");
        if (this.specialState_ != null) {
            this.specialState_.makeTextElement(buffer);
        }
        buffer.append("</historyState>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<historyState");
        buffer.print(">");
        if (this.specialState_ != null) {
            this.specialState_.makeTextElement(buffer);
        }
        buffer.print("</historyState>");
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode getParentRNode() {
        return this.parentRNode_;
    }

    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] getRNodes() {
        ArrayList<XSpecialState> classNodes = new ArrayList<XSpecialState>();
        if (this.specialState_ != null) {
            classNodes.add(this.specialState_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "historyState")) {
            return false;
        }
        RStack target = new RStack(element);
        XSpecialState.isMatchHungry(target);
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XHistoryState.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XHistoryState.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

