/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.IStateDiagramFactory;
import sdeditor.model.xml.RStack;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.UJAXP;
import sdeditor.model.xml.URelaxer;
import sdeditor.model.xml.XActions;
import sdeditor.model.xml.XEvents;
import sdeditor.model.xml.XGuardConditions;
import sdeditor.model.xml.XStateMachine;
import sdeditor.model.xml.XTransitions;

public class XRootStateMachine
implements Serializable,
IRNode {
    private XEvents events_;
    private XGuardConditions guardConditions_;
    private XActions actions_;
    private XTransitions transitions_;
    private XStateMachine stateMachine_;
    private IRNode parentRNode_;

    public XRootStateMachine() {
    }

    public XRootStateMachine(RStack stack) {
        this.setup(stack);
    }

    public XRootStateMachine(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XRootStateMachine(Element element) {
        this.setup(element);
    }

    public XRootStateMachine(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XRootStateMachine(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XRootStateMachine(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XRootStateMachine(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XRootStateMachine(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XRootStateMachine(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        IStateDiagramFactory factory = StateDiagramFactory.getFactory();
        RStack stack = new RStack(element);
        this.setEvents(factory.createXEvents(stack));
        this.setGuardConditions(factory.createXGuardConditions(stack));
        this.setActions(factory.createXActions(stack));
        this.setTransitions(factory.createXTransitions(stack));
        this.setStateMachine(factory.createXStateMachine(stack));
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("rootStateMachine");
        this.events_.makeElement(element);
        this.guardConditions_.makeElement(element);
        this.actions_.makeElement(element);
        this.transitions_.makeElement(element);
        this.stateMachine_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final XEvents getEvents() {
        return this.events_;
    }

    public final void setEvents(XEvents events) {
        this.events_ = events;
        if (events != null) {
            events.setParentRNode(this);
        }
    }

    public final XGuardConditions getGuardConditions() {
        return this.guardConditions_;
    }

    public final void setGuardConditions(XGuardConditions guardConditions) {
        this.guardConditions_ = guardConditions;
        if (guardConditions != null) {
            guardConditions.setParentRNode(this);
        }
    }

    public final XActions getActions() {
        return this.actions_;
    }

    public final void setActions(XActions actions) {
        this.actions_ = actions;
        if (actions != null) {
            actions.setParentRNode(this);
        }
    }

    public final XTransitions getTransitions() {
        return this.transitions_;
    }

    public final void setTransitions(XTransitions transitions) {
        this.transitions_ = transitions;
        if (transitions != null) {
            transitions.setParentRNode(this);
        }
    }

    public final XStateMachine getStateMachine() {
        return this.stateMachine_;
    }

    public final void setStateMachine(XStateMachine stateMachine) {
        this.stateMachine_ = stateMachine;
        if (stateMachine != null) {
            stateMachine.setParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<rootStateMachine");
        buffer.append(">");
        this.events_.makeTextElement(buffer);
        this.guardConditions_.makeTextElement(buffer);
        this.actions_.makeTextElement(buffer);
        this.transitions_.makeTextElement(buffer);
        this.stateMachine_.makeTextElement(buffer);
        buffer.append("</rootStateMachine>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<rootStateMachine");
        buffer.print(">");
        this.events_.makeTextElement(buffer);
        this.guardConditions_.makeTextElement(buffer);
        this.actions_.makeTextElement(buffer);
        this.transitions_.makeTextElement(buffer);
        this.stateMachine_.makeTextElement(buffer);
        buffer.print("</rootStateMachine>");
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode getParentRNode() {
        return this.parentRNode_;
    }

    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] getRNodes() {
        ArrayList<Serializable> classNodes = new ArrayList<Serializable>();
        classNodes.add(this.events_);
        classNodes.add(this.guardConditions_);
        classNodes.add(this.actions_);
        classNodes.add(this.transitions_);
        classNodes.add(this.stateMachine_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "rootStateMachine")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!XEvents.isMatchHungry(target)) {
            return false;
        }
        if (!XGuardConditions.isMatchHungry(target)) {
            return false;
        }
        if (!XActions.isMatchHungry(target)) {
            return false;
        }
        if (!XTransitions.isMatchHungry(target)) {
            return false;
        }
        if (!XStateMachine.isMatchHungry(target)) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XRootStateMachine.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XRootStateMachine.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

