/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.IStateDiagramFactory;
import sdeditor.model.xml.RStack;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.UJAXP;
import sdeditor.model.xml.URelaxer;
import sdeditor.model.xml.XCompositeStates;
import sdeditor.model.xml.XHistoryState;
import sdeditor.model.xml.XInitialState;
import sdeditor.model.xml.XTerminalStates;

public class XStateMachine
implements Serializable,
IRNode {
    private XCompositeStates compositeStates_;
    private XInitialState initialState_;
    private XTerminalStates terminalStates_;
    private XHistoryState historyState_;
    private IRNode parentRNode_;

    public XStateMachine() {
    }

    public XStateMachine(RStack stack) {
        this.setup(stack);
    }

    public XStateMachine(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XStateMachine(Element element) {
        this.setup(element);
    }

    public XStateMachine(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XStateMachine(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XStateMachine(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XStateMachine(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XStateMachine(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XStateMachine(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        IStateDiagramFactory factory = StateDiagramFactory.getFactory();
        RStack stack = new RStack(element);
        this.setCompositeStates(factory.createXCompositeStates(stack));
        this.setInitialState(factory.createXInitialState(stack));
        this.setTerminalStates(factory.createXTerminalStates(stack));
        this.setHistoryState(factory.createXHistoryState(stack));
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("stateMachine");
        this.compositeStates_.makeElement(element);
        this.initialState_.makeElement(element);
        this.terminalStates_.makeElement(element);
        this.historyState_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final XCompositeStates getCompositeStates() {
        return this.compositeStates_;
    }

    public final void setCompositeStates(XCompositeStates compositeStates) {
        this.compositeStates_ = compositeStates;
        if (compositeStates != null) {
            compositeStates.setParentRNode(this);
        }
    }

    public final XInitialState getInitialState() {
        return this.initialState_;
    }

    public final void setInitialState(XInitialState initialState) {
        this.initialState_ = initialState;
        if (initialState != null) {
            initialState.setParentRNode(this);
        }
    }

    public final XTerminalStates getTerminalStates() {
        return this.terminalStates_;
    }

    public final void setTerminalStates(XTerminalStates terminalStates) {
        this.terminalStates_ = terminalStates;
        if (terminalStates != null) {
            terminalStates.setParentRNode(this);
        }
    }

    public final XHistoryState getHistoryState() {
        return this.historyState_;
    }

    public final void setHistoryState(XHistoryState historyState) {
        this.historyState_ = historyState;
        if (historyState != null) {
            historyState.setParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<stateMachine");
        buffer.append(">");
        this.compositeStates_.makeTextElement(buffer);
        this.initialState_.makeTextElement(buffer);
        this.terminalStates_.makeTextElement(buffer);
        this.historyState_.makeTextElement(buffer);
        buffer.append("</stateMachine>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<stateMachine");
        buffer.print(">");
        this.compositeStates_.makeTextElement(buffer);
        this.initialState_.makeTextElement(buffer);
        this.terminalStates_.makeTextElement(buffer);
        this.historyState_.makeTextElement(buffer);
        buffer.print("</stateMachine>");
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode getParentRNode() {
        return this.parentRNode_;
    }

    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] getRNodes() {
        ArrayList<Serializable> classNodes = new ArrayList<Serializable>();
        classNodes.add(this.compositeStates_);
        classNodes.add(this.initialState_);
        classNodes.add(this.terminalStates_);
        classNodes.add(this.historyState_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "stateMachine")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!XCompositeStates.isMatchHungry(target)) {
            return false;
        }
        if (!XInitialState.isMatchHungry(target)) {
            return false;
        }
        if (!XTerminalStates.isMatchHungry(target)) {
            return false;
        }
        if (!XHistoryState.isMatchHungry(target)) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XStateMachine.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XStateMachine.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

