/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.IStateDiagramFactory;
import sdeditor.model.xml.RStack;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.UJAXP;
import sdeditor.model.xml.URelaxer;
import sdeditor.model.xml.XBendpoints;
import sdeditor.model.xml.XTransitionLabel;

public class XTransition
implements Serializable,
IRNode {
    private String source_;
    private String target_;
    private String event_;
    private String guardCondition_;
    private List actions_ = new ArrayList();
    private XBendpoints bendpoints_;
    private XTransitionLabel transitionLabel_;
    private IRNode parentRNode_;

    public XTransition() {
    }

    public XTransition(RStack stack) {
        this.setup(stack);
    }

    public XTransition(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XTransition(Element element) {
        this.setup(element);
    }

    public XTransition(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XTransition(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XTransition(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XTransition(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XTransition(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XTransition(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        IStateDiagramFactory factory = StateDiagramFactory.getFactory();
        RStack stack = new RStack(element);
        this.source_ = URelaxer.getAttributePropertyAsString(element, "source");
        this.target_ = URelaxer.getAttributePropertyAsString(element, "target");
        this.event_ = URelaxer.getAttributePropertyAsString(element, "event");
        this.guardCondition_ = URelaxer.getAttributePropertyAsString(element, "guardCondition");
        this.actions_ = URelaxer.getAttributePropertyAsStringList(element, "actions");
        this.setBendpoints(factory.createXBendpoints(stack));
        this.setTransitionLabel(factory.createXTransitionLabel(stack));
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("transition");
        URelaxer.setAttributePropertyByString(element, "source", this.source_);
        URelaxer.setAttributePropertyByString(element, "target", this.target_);
        URelaxer.setAttributePropertyByString(element, "event", this.event_);
        URelaxer.setAttributePropertyByString(element, "guardCondition", this.guardCondition_);
        URelaxer.setAttributePropertyByStringList(element, "actions", this.actions_);
        this.bendpoints_.makeElement(element);
        this.transitionLabel_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getSource() {
        return this.source_;
    }

    public final void setSource(String source) {
        this.source_ = source;
    }

    public final String getTarget() {
        return this.target_;
    }

    public final void setTarget(String target) {
        this.target_ = target;
    }

    public final String getEvent() {
        return this.event_;
    }

    public final void setEvent(String event) {
        this.event_ = event;
    }

    public final String getGuardCondition() {
        return this.guardCondition_;
    }

    public final void setGuardCondition(String guardCondition) {
        this.guardCondition_ = guardCondition;
    }

    public final String[] getActions() {
        String[] array = new String[this.actions_.size()];
        return this.actions_.toArray(array);
    }

    public final void setActions(String[] actions) {
        this.actions_.clear();
        this.actions_.addAll(Arrays.asList(actions));
    }

    public final void setActions(String actions) {
        this.actions_.clear();
        this.actions_.add(actions);
    }

    public final void addActions(String actions) {
        this.actions_.add(actions);
    }

    public final int getActionsCount() {
        return this.actions_.size();
    }

    public final String getActions(int index) {
        return (String)this.actions_.get(index);
    }

    public final void setActions(int index, String actions) {
        this.actions_.set(index, actions);
    }

    public final void removeActions(int index) {
        this.actions_.remove(index);
    }

    public final void removeActions(String actions) {
        this.actions_.remove(actions);
    }

    public final void clearActions() {
        this.actions_.clear();
    }

    public final XBendpoints getBendpoints() {
        return this.bendpoints_;
    }

    public final void setBendpoints(XBendpoints bendpoints) {
        this.bendpoints_ = bendpoints;
        if (bendpoints != null) {
            bendpoints.setParentRNode(this);
        }
    }

    public final XTransitionLabel getTransitionLabel() {
        return this.transitionLabel_;
    }

    public final void setTransitionLabel(XTransitionLabel transitionLabel) {
        this.transitionLabel_ = transitionLabel;
        if (transitionLabel != null) {
            transitionLabel.setParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<transition");
        buffer.append(" source=\"");
        buffer.append(URelaxer.escapeAttrQuot(this.getSource()));
        buffer.append("\"");
        buffer.append(" target=\"");
        buffer.append(URelaxer.escapeAttrQuot(this.getTarget()));
        buffer.append("\"");
        buffer.append(" event=\"");
        buffer.append(URelaxer.escapeAttrQuot(this.getEvent()));
        buffer.append("\"");
        buffer.append(" guardCondition=\"");
        buffer.append(URelaxer.escapeAttrQuot(this.getGuardCondition()));
        buffer.append("\"");
        buffer.append(" actions=\"");
        buffer.append(URelaxer.getString(this.getActions()));
        buffer.append("\"");
        buffer.append(">");
        this.bendpoints_.makeTextElement(buffer);
        this.transitionLabel_.makeTextElement(buffer);
        buffer.append("</transition>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<transition");
        buffer.print(" source=\"");
        buffer.print(URelaxer.escapeAttrQuot(this.getSource()));
        buffer.print("\"");
        buffer.print(" target=\"");
        buffer.print(URelaxer.escapeAttrQuot(this.getTarget()));
        buffer.print("\"");
        buffer.print(" event=\"");
        buffer.print(URelaxer.escapeAttrQuot(this.getEvent()));
        buffer.print("\"");
        buffer.print(" guardCondition=\"");
        buffer.print(URelaxer.escapeAttrQuot(this.getGuardCondition()));
        buffer.print("\"");
        buffer.print(" actions=\"");
        buffer.print(URelaxer.getString(this.getActions()));
        buffer.print("\"");
        buffer.print(">");
        this.bendpoints_.makeTextElement(buffer);
        this.transitionLabel_.makeTextElement(buffer);
        buffer.print("</transition>");
    }

    public String getSourceAsString() {
        return URelaxer.getString(this.getSource());
    }

    public String getTargetAsString() {
        return URelaxer.getString(this.getTarget());
    }

    public String getEventAsString() {
        return URelaxer.getString(this.getEvent());
    }

    public String getGuardConditionAsString() {
        return URelaxer.getString(this.getGuardCondition());
    }

    public String getActionsAsString() {
        return URelaxer.getString(this.getActions());
    }

    public void setSourceByString(String string) {
        this.setSource(string);
    }

    public void setTargetByString(String string) {
        this.setTarget(string);
    }

    public void setEventByString(String string) {
        this.setEvent(string);
    }

    public void setGuardConditionByString(String string) {
        this.setGuardCondition(string);
    }

    public void setActionsByString(String string) {
        this.setActions(URelaxer.getString(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode getParentRNode() {
        return this.parentRNode_;
    }

    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] getRNodes() {
        ArrayList<Serializable> classNodes = new ArrayList<Serializable>();
        classNodes.add(this.bendpoints_);
        classNodes.add(this.transitionLabel_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "transition")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!XBendpoints.isMatchHungry(target)) {
            return false;
        }
        if (!XTransitionLabel.isMatchHungry(target)) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XTransition.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XTransition.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

