/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.elementchooser;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.boxed_economy.components.elementchooser.ListPanel;
import org.boxed_economy.components.elementchooser.TitleDecorationPanel;
import org.boxed_economy.components.elementchooser.VerticalLayoutPanel;

public class ElementChoosePanel
extends JPanel {
    private List elements = null;
    private ListPanel addedElementsPanel = new ListPanel();
    private ListPanel removedElementsPanel = new ListPanel();
    private JButton addButton = new JButton("ADD >>");
    private JButton removeButton = new JButton("<< REMOVE");
    private String removedMessage = "Removed Elements";
    private String addedMessage = "Added Elements";

    public ElementChoosePanel() {
        this(new ArrayList());
    }

    public ElementChoosePanel(List elements) {
        this(elements, new ArrayList());
    }

    public ElementChoosePanel(List elements, List addedElements) {
        this(elements, addedElements, "", "");
    }

    public ElementChoosePanel(String removedMessage, String addedMessage) {
        this(new ArrayList(), new ArrayList(), removedMessage, addedMessage);
    }

    public ElementChoosePanel(List elements, List addedElements, String removedMessage, String addedMessage) {
        this.removedMessage = removedMessage;
        this.addedMessage = addedMessage;
        this.setElements(elements, addedElements);
        this.initialize();
        this.buttonStateUpdated();
    }

    private void initialize() {
        this.setPreferredSize(new Dimension(600, 260));
        JPanel addRemovePanel = this.createAddRemovePanel();
        this.addedElementsPanel.setPreferredSize(new Dimension(200, 200));
        this.addedElementsPanel.getJList().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ElementChoosePanel.this.buttonStateUpdated();
            }
        });
        this.removedElementsPanel.setPreferredSize(new Dimension(200, 200));
        this.removedElementsPanel.getJList().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ElementChoosePanel.this.buttonStateUpdated();
            }
        });
        this.add(new TitleDecorationPanel(this.removedMessage, this.removedElementsPanel));
        this.add(addRemovePanel);
        this.add(new TitleDecorationPanel(this.addedMessage, this.addedElementsPanel));
    }

    private JPanel createAddRemovePanel() {
        VerticalLayoutPanel addremovePanel = new VerticalLayoutPanel();
        this.addButton.setPreferredSize(new Dimension(80, 27));
        this.addButton.setMargin(new Insets(2, 2, 2, 2));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ElementChoosePanel.this.add();
            }
        });
        this.removeButton.setPreferredSize(new Dimension(80, 27));
        this.removeButton.setMargin(new Insets(2, 2, 2, 2));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ElementChoosePanel.this.remove();
            }
        });
        addremovePanel.add(this.addButton);
        addremovePanel.add(this.removeButton);
        return addremovePanel;
    }

    private void add() {
        this.move(this.removedElementsPanel, this.addedElementsPanel);
    }

    private void remove() {
        this.move(this.addedElementsPanel, this.removedElementsPanel);
    }

    private void move(ListPanel source, ListPanel target) {
        int[] selectedIndices = source.getJList().getSelectedIndices();
        if (selectedIndices.length > 0) {
            this.moveElements(source, target, selectedIndices);
        }
        this.buttonStateUpdated();
    }

    private void moveElements(ListPanel source, ListPanel target, int[] indices) {
        if (this.elements == null) {
            throw new RuntimeException("elements have not been set");
        }
        List moveElements = this.removeAll(source.getList(), indices);
        if (!this.elements.containsAll(moveElements)) {
            throw new RuntimeException("illegal moveElements");
        }
        source.refresh();
        target.getList().addAll(moveElements);
        target.refresh();
    }

    private List removeAll(List list, int[] indices) {
        ArrayList removedElements = new ArrayList();
        int removeCount = 0;
        int len = indices.length;
        int i = 0;
        while (i < len) {
            removedElements.add(list.remove(indices[i - removeCount]));
            ++removeCount;
            ++i;
        }
        return removedElements;
    }

    public List getAddedElements() {
        return this.addedElementsPanel.getList();
    }

    public List getRemovedElements() {
        return this.removedElementsPanel.getList();
    }

    public List getElements() {
        return this.elements;
    }

    public void setElements(List elements, List addElements) {
        this.setElements(elements);
        this.addElements(addElements);
    }

    public void setElements(List elements) {
        if (this.elements != null) {
            this.addedElementsPanel.getList().clear();
            this.addedElementsPanel.refresh();
            this.removedElementsPanel.getList().clear();
            this.removedElementsPanel.refresh();
        }
        this.elements = elements;
        if (this.elements != null) {
            this.removedElementsPanel.getList().addAll(elements);
            this.removedElementsPanel.refresh();
        }
    }

    private void addElements(List addElements) {
        int[] indices = this.getIndices(this.elements, addElements);
        this.moveElements(this.removedElementsPanel, this.addedElementsPanel, indices);
    }

    private int[] getIndices(List all, List elements) {
        int len = all.size();
        int amount = 0;
        int i = 0;
        while (i < len) {
            if (elements.contains(all.get(i))) {
                ++amount;
            }
            ++i;
        }
        int[] indices = new int[amount];
        int counter = 0;
        int i2 = 0;
        while (i2 < len) {
            if (elements.contains(all.get(i2))) {
                indices[counter] = i2;
                ++counter;
            }
            ++i2;
        }
        return indices;
    }

    public void buttonStateUpdated() {
        int selectedIndex = this.removedElementsPanel.getJList().getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < this.removedElementsPanel.getList().size()) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
        selectedIndex = this.addedElementsPanel.getJList().getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < this.addedElementsPanel.getList().size()) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 320);
        ElementChoosePanel listPanel = new ElementChoosePanel("added", "removed");
        frame.getContentPane().add(new TitleDecorationPanel("Hello!", listPanel));
        frame.show();
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> list2 = new ArrayList<String>();
        list.add("\u3042");
        list.add("\u3044");
        list.add("\u3046");
        list.add("\u3048");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list2.add("\u3042");
        list2.add("\u3044");
        list2.add("\u3046");
        listPanel.setElements(list, list2);
    }
}

