/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.elementchooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.boxed_economy.components.elementchooser.ListPanel;
import org.boxed_economy.components.elementchooser.VerticalLayoutPanel;

public class UpDownListPanel
extends JPanel {
    private ListPanel listPanel = null;
    private JButton upButton = new JButton("UP");
    private JButton downButton = new JButton("DN");

    public UpDownListPanel() {
        this(new ArrayList());
    }

    public UpDownListPanel(List list) {
        this.listPanel = new ListPanel(list);
        this.initialize();
        this.buttonStateUpdated();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel updownPanel = this.createUpDownPanel();
        this.listPanel.getJList().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                UpDownListPanel.this.buttonStateUpdated();
            }
        });
        this.add((Component)this.listPanel, "Center");
        this.add((Component)updownPanel, "East");
    }

    private JPanel createUpDownPanel() {
        VerticalLayoutPanel updownPanel = new VerticalLayoutPanel();
        this.upButton.setPreferredSize(new Dimension(30, 27));
        this.upButton.setMargin(new Insets(2, 2, 2, 2));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpDownListPanel.this.up();
            }
        });
        this.downButton.setPreferredSize(new Dimension(30, 27));
        this.downButton.setMargin(new Insets(2, 2, 2, 2));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpDownListPanel.this.down();
            }
        });
        updownPanel.add(this.upButton);
        updownPanel.add(this.downButton);
        return updownPanel;
    }

    private void up() {
        this.move(-1);
    }

    private void down() {
        this.move(1);
    }

    private void move(int move) {
        JList jList = this.listPanel.getJList();
        List list = this.listPanel.getList();
        int selectedIndex = jList.getSelectedIndex();
        int movedIndex = selectedIndex + move;
        Object object = list.remove(selectedIndex);
        list.add(movedIndex, object);
        this.listPanel.refresh();
        jList.setSelectedIndex(movedIndex);
    }

    public ListPanel getListPanel() {
        return this.listPanel;
    }

    public void buttonStateUpdated() {
        int selectedIndex = this.listPanel.getJList().getSelectedIndex();
        if (selectedIndex > 0 && selectedIndex <= this.listPanel.getList().size() - 1) {
            this.upButton.setEnabled(true);
        } else {
            this.upButton.setEnabled(false);
        }
        if (selectedIndex >= 0 && selectedIndex < this.listPanel.getList().size() - 1) {
            this.downButton.setEnabled(true);
        } else {
            this.downButton.setEnabled(false);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(300, 300);
        UpDownListPanel listPanel = new UpDownListPanel();
        frame.getContentPane().add(listPanel);
        frame.show();
        ArrayList<String> list = new ArrayList<String>();
        list.add("\u3042");
        list.add("\u3044");
        list.add("\u3046");
        listPanel.getListPanel().setList(list);
        list.add("\u3048");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        list.add("\u3059\u3054\u304f\u9577\u3044\u3082\u306e\u306a\u3089\u3069\u3046\u306a\u308b\u3067\u3057\u3087\u3046\u304b\uff1f");
        listPanel.getListPanel().refresh();
    }
}

