/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.relationview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.besp.presentation.gui.AbstractInternalFrameComponent;
import org.boxed_economy.components.relationview.TypeSelectionPanel;
import org.boxed_economy.components.relationview.UpdateViewModelListener;
import org.boxed_economy.components.relationview.canvas.AbstractRelationViewCanvas;
import org.boxed_economy.components.relationview.canvas.CircleRelationViewCanvas;
import org.boxed_economy.components.relationview.canvas.CollaborationGraphCanvas;
import org.boxed_economy.components.relationview.canvas.LayerRelationViewCanvas;
import org.boxed_economy.components.relationview.canvas.RandomRelationViewCanvas;

public class RelationViewer
extends AbstractInternalFrameComponent
implements ModelContainerListener,
UpdateClockListener,
UpdateViewModelListener,
SimulationStateListener {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private List canvases = new ArrayList();
    private TypeSelectionPanel agentTypeSelection = null;
    private TypeSelectionPanel relationTypeSelection = null;

    public void initialize() {
        this.initializeComponents();
        this.addUpdateClockListener(this);
    }

    private void initializeComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(new Dimension(600, 400));
        JPanel selectionPanel = this.createTypeSelectionPanels();
        this.initializeCanvases();
        this.getContentPane().add((Component)selectionPanel, "West");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
    }

    private JPanel createTypeSelectionPanels() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 0));
        Collection agentTypes = this.getPresentationContainer().getModelContainer().getAgentTypes();
        this.agentTypeSelection = new TypeSelectionPanel((Frame)this.getMainFrame(), new ArrayList(agentTypes), "AgentType");
        this.agentTypeSelection.addUpdateViewModelListener(this);
        Collection relationTypes = this.getPresentationContainer().getModelContainer().getRelationTypes();
        this.relationTypeSelection = new TypeSelectionPanel((Frame)this.getMainFrame(), new ArrayList(relationTypes), "RelationType");
        this.relationTypeSelection.addUpdateViewModelListener(this);
        panel.add(this.agentTypeSelection);
        panel.add(this.relationTypeSelection);
        return panel;
    }

    private void initializeCanvases() {
        CircleRelationViewCanvas circle = new CircleRelationViewCanvas(this.agentTypeSelection, this.relationTypeSelection);
        circle.setEnabled(false);
        this.tabbedPane.add("Circle", circle);
        LayerRelationViewCanvas layer = new LayerRelationViewCanvas(this.agentTypeSelection, this.relationTypeSelection);
        layer.setEnabled(false);
        this.tabbedPane.add("Layer", layer);
        RandomRelationViewCanvas random = new RandomRelationViewCanvas(this.agentTypeSelection, this.relationTypeSelection);
        random.setEnabled(false);
        this.tabbedPane.add("Random", random);
        CollaborationGraphCanvas graph = new CollaborationGraphCanvas(this.agentTypeSelection, this.relationTypeSelection);
        graph.setEnabled(false);
        this.tabbedPane.add("Graph", graph);
    }

    public void terminate() {
        this.removeUpdateClockListener(this);
    }

    public void prepareWorldClose(ModelContainerEvent ev) {
    }

    public void prepareWorldOpen(ModelContainerEvent ev) {
    }

    public void worldClosed(ModelContainerEvent ev) {
        Component[] components = this.tabbedPane.getComponents();
        int i = 0;
        while (i < components.length) {
            AbstractRelationViewCanvas canvas = (AbstractRelationViewCanvas)components[i];
            canvas.setEnabled(false);
            canvas.setWorld(null);
            ++i;
        }
    }

    public void worldOpened(ModelContainerEvent ev) {
        Component[] components = this.tabbedPane.getComponents();
        int i = 0;
        while (i < components.length) {
            AbstractRelationViewCanvas canvas = (AbstractRelationViewCanvas)components[i];
            canvas.setEnabled(true);
            canvas.setWorld(this.getWorld());
            ++i;
        }
    }

    public void viewModelUpdated() {
        Component[] components = this.tabbedPane.getComponents();
        int i = 0;
        while (i < components.length) {
            AbstractRelationViewCanvas canvas = (AbstractRelationViewCanvas)components[i];
            canvas.updateAll();
            ++i;
        }
    }

    public void clockGained(UpdateClockEvent e) {
        ((AbstractRelationViewCanvas)this.tabbedPane.getSelectedComponent()).updateAll();
    }

    public void simulationStarted(SimulationStateEvent ev) {
    }

    public void simulationStopped(SimulationStateEvent ev) {
    }

    public void simulationStopping(SimulationStateEvent ev) {
        this.repaint();
    }
}

