/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.relationview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.boxed_economy.components.elementchooser.ElementChooser;
import org.boxed_economy.components.elementchooser.ListPanel;
import org.boxed_economy.components.elementchooser.UpDownListPanel;
import org.boxed_economy.components.relationview.TypeSelection;
import org.boxed_economy.components.relationview.UpdateViewModelListener;

public class TypeSelectionPanel
extends JPanel
implements TypeSelection,
ListDataListener {
    private String title = "";
    private ListPanel listPanel = new ListPanel();
    private List types = null;
    private Frame owner = null;
    private List updateListeners = new ArrayList();

    public TypeSelectionPanel(Frame owner, List types, String title) {
        this.owner = owner;
        this.types = types;
        this.title = title;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(this.title));
        UpDownListPanel updownListPanel = new UpDownListPanel();
        this.listPanel = updownListPanel.getListPanel();
        this.listPanel.setList(new ArrayList(this.types));
        this.listPanel.getModel().addListDataListener(this);
        JPanel south = this.createButtonPanel();
        this.add((Component)updownListPanel, "Center");
        this.add((Component)south, "South");
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        JButton button = new JButton();
        button.setText("Arrange");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TypeSelectionPanel.this.arrangeSelectedTypes();
            }
        });
        panel.add(button);
        return panel;
    }

    public void arrangeSelectedTypes() {
        ArrayList allTypes = new ArrayList();
        List selectedTypes = this.listPanel.getList();
        allTypes.addAll(this.types);
        allTypes.removeAll(selectedTypes);
        allTypes.addAll(selectedTypes);
        List selected = ElementChooser.open(this.owner, allTypes, selectedTypes, "Type Chooser", "Please, Arrange Hide/Show Types", "Hide Types", "Show Types");
        if (selected != null) {
            this.listPanel.getModel().removeListDataListener(this);
            this.listPanel.setList(selected);
            this.listPanel.getModel().addListDataListener(this);
            this.fireViewModelUpdated();
        }
    }

    public List getSelectedTypes() {
        return this.listPanel.getList();
    }

    public void contentsChanged(ListDataEvent e) {
        this.fireViewModelUpdated();
    }

    public void intervalAdded(ListDataEvent e) {
        this.fireViewModelUpdated();
    }

    public void intervalRemoved(ListDataEvent e) {
        this.fireViewModelUpdated();
    }

    public void addUpdateViewModelListener(UpdateViewModelListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeUpdateViewModelListener(UpdateViewModelListener listener) {
        this.updateListeners.remove(listener);
    }

    public void fireViewModelUpdated() {
        Iterator i = this.updateListeners.iterator();
        while (i.hasNext()) {
            UpdateViewModelListener listener = (UpdateViewModelListener)i.next();
            listener.viewModelUpdated();
        }
    }
}

