/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.relationview.canvas;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.RelationType;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.components.relationview.AgentNode;
import org.boxed_economy.components.relationview.TypeSelection;

public abstract class AbstractRelationViewCanvas
extends JPanel {
    private static final Point DEFAULT_LOCATION = new Point(10, 10);
    private World world = null;
    private TypeSelection agentTypeSelection = null;
    private TypeSelection relationTypeSelection = null;
    protected Map nodes = new HashMap();
    private Map nodesByType = new HashMap();

    public AbstractRelationViewCanvas(TypeSelection agentSelection, TypeSelection relationSelection) {
        this.agentTypeSelection = agentSelection;
        this.relationTypeSelection = relationSelection;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(null);
        this.setBackground(Color.white);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateAll();
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.layoutNodes();
    }

    public void updateAll() {
        if (this.world != null && this.isEnabled()) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.updateNodes();
                this.layoutNodes();
                this.repaint();
            }
        }
    }

    private void updateNodes() {
        if (this.world != null) {
            Agent agent;
            List suitableAgents = this.getAllSuitableAgents();
            Set availableAgents = this.nodes.keySet();
            ArrayList addAgents = new ArrayList(suitableAgents);
            addAgents.removeAll(availableAgents);
            Iterator i = addAgents.iterator();
            while (i.hasNext()) {
                agent = (Agent)i.next();
                this.addAgentNode(agent);
            }
            ArrayList removeAgents = new ArrayList(availableAgents);
            removeAgents.removeAll(suitableAgents);
            i = removeAgents.iterator();
            while (i.hasNext()) {
                agent = (Agent)i.next();
                this.removeAgentNode(agent);
            }
        }
    }

    protected void layoutNodes() {
    }

    private List getAllSuitableAgents() {
        List agentTypes = this.agentTypeSelection.getSelectedTypes();
        ArrayList agents = new ArrayList();
        Iterator i = agentTypes.iterator();
        while (i.hasNext()) {
            AgentType agentType = (AgentType)i.next();
            agents.addAll(this.getWorld().getAgents(agentType));
        }
        return agents;
    }

    protected AgentNode addAgentNode(Agent agent) {
        AgentNode node = new AgentNode(agent);
        node.setLocation(DEFAULT_LOCATION);
        this.add(node);
        this.nodes.put(agent, node);
        this.getNodes(agent.getType()).add(node);
        return node;
    }

    protected AgentNode removeAgentNode(Agent agent) {
        AgentNode node = (AgentNode)this.nodes.get(agent);
        this.remove(node);
        this.nodes.remove(agent);
        this.getNodes(agent.getType()).remove(node);
        return node;
    }

    public Set getAllAgents() {
        return this.nodes.keySet();
    }

    public Collection getAllNodes() {
        return this.nodes.values();
    }

    public List getOrderedAllNodes() {
        ArrayList allNodes = new ArrayList();
        Iterator i = this.agentTypeSelection.getSelectedTypes().iterator();
        while (i.hasNext()) {
            AgentType type = (AgentType)i.next();
            allNodes.addAll(this.getNodes(type));
        }
        return allNodes;
    }

    public List getNodes(AgentType type) {
        if (!this.nodesByType.containsKey(type)) {
            this.nodesByType.put(type, new ArrayList());
        }
        return (List)this.nodesByType.get(type);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintAgents(g);
    }

    public void paintAgents(Graphics g) {
        Set agents = this.nodes.keySet();
        Iterator i = agents.iterator();
        while (i.hasNext()) {
            Agent agent = (Agent)i.next();
            this.paintLabel(g, agent);
            this.paintRelations(g, agents, agent);
        }
    }

    public void paintRelations(Graphics g, Set agents, Agent source) {
        List relationTypes = this.relationTypeSelection.getSelectedTypes();
        Iterator j = relationTypes.iterator();
        while (j.hasNext()) {
            RelationType relationType = (RelationType)j.next();
            Collection relations = source.getRelations(relationType);
            Iterator k = relations.iterator();
            while (k.hasNext()) {
                Relation relation = (Relation)k.next();
                Agent target = relation.getTarget();
                if (!agents.contains(target)) continue;
                this.paintRelation(g, source, target);
            }
        }
    }

    private void paintRelation(Graphics g, Agent source, Agent target) {
        AgentNode sourceNode = (AgentNode)this.nodes.get(source);
        AgentNode targetNode = (AgentNode)this.nodes.get(target);
        Point sourcePoint = sourceNode.getCenter();
        Point targetPoint = targetNode.getCenter();
        g.drawLine(sourcePoint.x, sourcePoint.y, targetPoint.x, targetPoint.y);
        this.paintArrow(g, sourcePoint.x, sourcePoint.y, targetPoint.x, targetPoint.y);
    }

    private void paintArrow(Graphics g, int node1x, int node1y, int node2x, int node2y) {
        int x1 = node1x;
        int y1 = node1y;
        int x2 = (int)((double)node1x + (double)(node2x - node1x) / 2.5);
        int y2 = (int)((double)node1y + (double)(node2y - node1y) / 2.5);
        if (x2 - x1 != 0 || y2 - y2 != 0) {
            int arrow = 6;
            double dd = 0.6;
            double d = Math.atan2(y2 - y1, x2 - x1);
            double xa = (double)x2 - (double)arrow * Math.cos(d + dd);
            double ya = (double)y2 - (double)arrow * Math.sin(d + dd);
            g.drawLine(x2, y2, (int)xa, (int)ya);
            double xb = (double)x2 - (double)arrow * Math.cos(d - dd);
            double yb = (double)y2 - (double)arrow * Math.sin(d - dd);
            g.drawLine(x2, y2, (int)xb, (int)yb);
        }
    }

    private void paintLabel(Graphics g, Agent agent) {
        AgentNode node = (AgentNode)this.nodes.get(agent);
        String text = agent.getType().getName();
        Point point = node.getLocation();
        Point labelPoint = node.getLabelLocation();
        point.translate(labelPoint.x, labelPoint.y);
        g.drawString(text, point.x, point.y);
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
        this.updateAll();
    }

    public TypeSelection getAgentTypeSelection() {
        return this.agentTypeSelection;
    }

    public TypeSelection getRelationTypeSelection() {
        return this.relationTypeSelection;
    }

    public Map getNodesMap() {
        return this.nodes;
    }
}

