/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.relationview.canvas;

import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.boxed_economy.components.relationview.AgentNode;
import org.boxed_economy.components.relationview.TypeSelection;
import org.boxed_economy.components.relationview.canvas.AbstractRelationViewCanvas;

public class CircleRelationViewCanvas
extends AbstractRelationViewCanvas {
    private static final int CHAR_WIDTH = 6;
    private static final int CHAR_HEIGHT = 6;
    private int margin = 50;

    public CircleRelationViewCanvas(TypeSelection agentTypes, TypeSelection relationTypes) {
        super(agentTypes, relationTypes);
    }

    protected void layoutNodes() {
        ArrayList nodes = new ArrayList(super.getOrderedAllNodes());
        int width = this.getWidth();
        int height = this.getHeight();
        int amount = nodes.size();
        int radius = (width > height ? height / 2 : width / 2) - this.margin;
        Point center = new Point(width / 2, height / 2);
        int i = 0;
        while (i < amount) {
            AgentNode node = (AgentNode)nodes.get(i);
            Point location = this.calculateCircumferentialLocation(center, radius, amount, i, node);
            node.setLocation(location);
            Point labelLocation = this.calculateCircumferentialLabelLocation(center, node);
            node.setLabelLocation(labelLocation);
            ++i;
        }
    }

    private Point calculateCircumferentialLocation(Point center, int radius, int amount, int count, AgentNode node) {
        double radian = Math.PI * 2 * ((double)(count % amount) / (double)amount);
        int x = (int)(Math.sin(radian) * (double)radius + (double)center.x) - node.getWidth() / 2;
        int y = (int)(-Math.cos(radian) * (double)radius + (double)center.y) - node.getHeight() / 2;
        return new Point(x, y);
    }

    private Point calculateCircumferentialLabelLocation(Point center, AgentNode node) {
        int y;
        int x;
        String text = node.getAgent().getType().getName();
        if (node.getX() >= center.x) {
            x = node.getWidth();
        } else {
            x = 0;
            x -= this.computeStringLength(text);
        }
        if (node.getY() <= center.y) {
            y = 0;
        } else {
            y = node.getHeight();
            y += 6;
        }
        return new Point(x, y);
    }

    private int computeStringLength(String text) {
        Graphics g = this.getGraphics();
        if (g == null) {
            return text.length() * 6;
        }
        return SwingUtilities.computeStringWidth(g.getFontMetrics(), text);
    }

    public static void main(String[] args) {
        CircleRelationViewCanvas canvas = new CircleRelationViewCanvas(null, null);
        int radius = 100;
        int amount = 8;
        int nodeSize = 10;
        Point center = new Point(100, 100);
        int i = 0;
        while (i < amount) {
            Point p = canvas.calculateCircumferentialLocation(center, radius, amount, i, new AgentNode(null));
            System.out.println("p.x=" + p.x + " p.y=" + p.y);
            ++i;
        }
    }
}

