/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.relationview.setting;

import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import org.boxed_economy.components.relationview.setting.ColorListCellRenderer;

public class ColorChooseComboBox
extends JComboBox {
    private List colors = null;
    private Color extraColor = null;

    public ColorChooseComboBox(List colors) {
        this.colors = colors;
        this.initializeComponent();
        this.initializeItems();
    }

    private void initializeComponent() {
        this.setBackground(Color.white);
        this.setRenderer(new ColorListCellRenderer());
    }

    private void initializeItems() {
        Iterator i = this.colors.iterator();
        while (i.hasNext()) {
            Color element = (Color)i.next();
            this.addItem(element);
        }
    }

    public Color getSelectedColor() {
        return (Color)this.getSelectedItem();
    }

    public void setSelectedColor(Color color) {
        if (!this.colors.contains(color)) {
            this.setExtraColor(color);
        }
        this.setSelectedItem(color);
    }

    private void setExtraColor(Color extraColor) {
        if (this.extraColor != null) {
            this.removeItem(this.extraColor);
        }
        this.extraColor = extraColor;
        if (this.extraColor != null) {
            this.addItem(this.extraColor);
        }
    }
}

