/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.relationview.setting;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ColorListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final Dimension DEFAULT_SIZE = new Dimension(40, 15);
    private static final Dimension DEFAULT_COLOR_RECT_SIZE = new Dimension(30, 10);
    private Dimension rectSize = DEFAULT_COLOR_RECT_SIZE;
    private Color color = null;

    public ColorListCellRenderer() {
        this.setPreferredSize(DEFAULT_SIZE);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.color = (Color)value;
        return this;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.color);
        int x = this.getWidth() / 2 - this.rectSize.width / 2;
        int y = this.getHeight() / 2 - this.rectSize.height / 2;
        g.fillRect(x, y, this.rectSize.width, this.rectSize.height);
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }
}

