/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.relationview.setting;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.boxed_economy.components.elementchooser.VerticalLayoutPanel;
import org.boxed_economy.components.relationview.setting.ColorChooseComboBox;

public class InstantColorChooser
extends JPanel {
    private static final String CHOOSE_BUTTON_TEXT = "other";
    private static final List DEFAULT_COLOR_LIST = new ArrayList();
    private static final JColorChooser chooser;
    private ColorChooseComboBox combobox = new ColorChooseComboBox(DEFAULT_COLOR_LIST);

    static {
        DEFAULT_COLOR_LIST.add(Color.black);
        DEFAULT_COLOR_LIST.add(Color.red);
        DEFAULT_COLOR_LIST.add(Color.blue);
        DEFAULT_COLOR_LIST.add(Color.yellow);
        DEFAULT_COLOR_LIST.add(Color.green);
        chooser = new JColorChooser();
    }

    public InstantColorChooser() {
        this(Color.black);
    }

    public InstantColorChooser(Color initialSelectedColor) {
        this.setSelectedColor(initialSelectedColor);
        this.initialize();
    }

    private void initialize() {
        JButton chooserButton = new JButton(CHOOSE_BUTTON_TEXT);
        chooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstantColorChooser.this.choose();
            }
        });
        chooserButton.setMargin(new Insets(0, 5, 0, 5));
        this.add(this.combobox);
        this.add(chooserButton);
    }

    public Color getSelectedColor() {
        return this.combobox.getSelectedColor();
    }

    public void setSelectedColor(Color color) {
        this.combobox.setSelectedColor(color);
    }

    private void choose() {
        Color color = JColorChooser.showDialog(this, "ColorChooser", this.combobox.getSelectedColor());
        if (color != null) {
            this.setSelectedColor(color);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(300, 300);
        VerticalLayoutPanel listPanel = new VerticalLayoutPanel();
        listPanel.add(new InstantColorChooser(Color.red));
        listPanel.add(new InstantColorChooser(Color.blue));
        listPanel.add(new InstantColorChooser(Color.lightGray));
        frame.getContentPane().add(listPanel);
        frame.show();
    }
}

