/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.evolvingnetwork.model.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.evolvingnetwork.model.EvolvingNetworkModel;
import org.boxed_economy.evolvingnetwork.model.behavior.AbstractPreferentialAttachBehavior;
import org.boxed_economy.evolvingnetwork.model.behavior.CSVwriter;

public class PreferentialAttachBehavior
extends AbstractPreferentialAttachBehavior {
    private int printTurn = 0;
    private CSVwriter writer = new CSVwriter();

    protected void initialize() {
    }

    protected void terminate() {
    }

    protected void preferentialAttachAction() {
        Agent node2;
        Agent node1;
        Collection nodes = this.getWorld().getAgents(EvolvingNetworkModel.AGENT_Node);
        Agent newNode = this.getWorld().createAgent(EvolvingNetworkModel.AGENT_Node);
        this.getAgent().addRelation(EvolvingNetworkModel.RELATION_Subject, newNode);
        Collection cumulativeLinkNumList = this.investigateLinkNum(nodes);
        if (nodes.size() >= 2) {
            node1 = this.preferentialSelect(cumulativeLinkNumList, nodes);
            node2 = null;
            while (node1 == (node2 = this.preferentialSelect(cumulativeLinkNumList, nodes))) {
            }
        } else {
            throw new ModelException("Model Error: You must prepare more than 1 Agent" + (Object)((Object)this));
        }
        newNode.addRelation(EvolvingNetworkModel.RELATION_Link, node1);
        node1.addRelation(EvolvingNetworkModel.RELATION_Link, newNode);
        newNode.addRelation(EvolvingNetworkModel.RELATION_Link, node2);
        node2.addRelation(EvolvingNetworkModel.RELATION_Link, newNode);
        this.testWriter();
    }

    private Collection investigateLinkNum(Collection nodes) {
        Iterator i = nodes.iterator();
        ArrayList<Integer> cumulativeLinkNum = new ArrayList<Integer>();
        int totalLinkNum = 0;
        while (i.hasNext()) {
            Agent agent = (Agent)i.next();
            int linkNum = agent.getRelations(EvolvingNetworkModel.RELATION_Link).size();
            cumulativeLinkNum.add(new Integer(totalLinkNum += linkNum));
        }
        return cumulativeLinkNum;
    }

    private Agent preferentialSelect(Collection cumulativeLinkNumList, Collection nodes) {
        int totalLinkNum = (Integer)((List)cumulativeLinkNumList).get(cumulativeLinkNumList.size() - 1);
        int random = this.getWorld().getRandomNumberGenerator().generate(totalLinkNum);
        Iterator i = cumulativeLinkNumList.iterator();
        Iterator j = nodes.iterator();
        while (j.hasNext()) {
            int cumulativeLinkNum = (Integer)i.next();
            Agent agent = (Agent)j.next();
            if (cumulativeLinkNum <= random) continue;
            return agent;
        }
        throw new ModelException("error at PreferentialAttachBehavior " + (Object)((Object)this));
    }

    private void testWriter() {
        ++this.printTurn;
        if (this.printTurn == 3000) {
            StringBuffer data = new StringBuffer();
            ArrayList<Integer> nums = new ArrayList<Integer>();
            Iterator i = this.getWorld().getAgents(EvolvingNetworkModel.AGENT_Node).iterator();
            while (i.hasNext()) {
                Integer num = new Integer(((List)((Agent)i.next()).getRelations(EvolvingNetworkModel.RELATION_Link)).size());
                nums.add(num);
            }
            Collections.sort(nums);
            Collections.reverse(nums);
            i = nums.iterator();
            while (i.hasNext()) {
                System.out.print(String.valueOf((Integer)i.next()) + "\n");
                data.append(String.valueOf((Integer)i.next()) + "\n");
            }
            this.printTurn = 0;
            String s = new String(data);
            this.writer.write("PreferentialAttachmentWorld_Seed" + this.getWorld().getDefaultRandomSeed() + "..csv", s);
        }
    }
}

