package org.boxed_economy.evolvingnetwork.model;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.RelationType;
import org.boxed_economy.evolvingnetwork.model.behavior.PreferentialAttachBehavior;
import org.boxed_economy.evolvingnetwork.model.behavior.RandomAttachBehavior;
import org.boxed_economy.evolvingnetwork.model.behavior.RandomNetworkingBehavior;

/**
 * @author iba
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class EvolvingNetworkModel implements BESPPlugin{
	
	//G[WFg
	public static AgentType AGENT_Node = null;
	public static AgentType AGENT_Organizer = null;
	
	//֌W
	public static RelationType RELATION_Link = null;
	public static RelationType RELATION_Subject = null;
	
	//s
	public static BehaviorType BEHAVIOR_RandomAttach = null;
	public static BehaviorType BEHAVIOR_PreferentialAttach = null;
	public static BehaviorType BEHAVIOR_RandomNetworking = null;
	
	/**
	 * \bh
	 */
	
	public static void initializePlugin(BESPContainer bespContainer){
		//TypeCXg[邽߂̃fRei擾
		ModelContainer container = bespContainer.getModelContainer();
		
		//AgentTypȅ
		AGENT_Node = container.installAgentType("Node");
		AGENT_Organizer = container.installAgentType("Organizer");
			
		//RelationTypȅ
		RELATION_Link = container.installRelationType("Link");
		RELATION_Subject = container.installRelationType("Subject");
		
		//BehaviorTypȅ
		BEHAVIOR_RandomAttach = container.installBehaviorType(RandomAttachBehavior.class.getName());
		BEHAVIOR_PreferentialAttach = container.installBehaviorType(PreferentialAttachBehavior.class.getName());
		BEHAVIOR_RandomNetworking = container.installBehaviorType(RandomNetworkingBehavior.class.getName());

	}

}
