package org.boxed_economy.evolvingnetwork.model;

import java.util.ArrayList;
import java.util.Iterator;

import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.components.stepclock.StepClock;

/**
 * @author iba
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class PreferentialAttachmentWorld extends World {

	
	public static void main(String[] args) {
		String[] arguments =
			new String[] { "-model", PreferentialAttachmentWorld.class.getName()};
		BESP.main(arguments);
	}
	
	//
	public void initializeWorld() {
	
		super.initializeWorld();
		//v܂
		this.setClock(new StepClock());

		
		Agent organizer = this.createOrganizer();

		//G[WFg𐶐܂
		for(int i=0; i<4; i++){
			this.createNode(organizer);
		}
	

		ArrayList nodes =
			(ArrayList) this.getAgents(EvolvingNetworkModel.AGENT_Node);
		Iterator i = this.getAgents(EvolvingNetworkModel.AGENT_Node).iterator();

		while(i.hasNext()) {
			//_ɌԂQ̊m[hI
			Agent node1 =
				((Agent) nodes
					.get(
						this.getRandomNumberGenerator().generate(
							nodes.size())));
			Agent node2;

			do {
				node2 =
					((Agent) nodes
						.get(
							this.getRandomNumberGenerator().generate(
								nodes.size())));
			} while (node1 == node2);

			//Vm[hƁÂQ̊m[hAoɌ		
			Agent sourceNode = (Agent) i.next();
			sourceNode.addRelation(EvolvingNetworkModel.RELATION_Link, node1);
			node1.addRelation(EvolvingNetworkModel.RELATION_Link, sourceNode);
			sourceNode.addRelation(EvolvingNetworkModel.RELATION_Link, node2);
			node2.addRelation(EvolvingNetworkModel.RELATION_Link, sourceNode);
		}
	
	
	}

	/**
	 * Organizer𐶐܂
	 */
	private Agent createOrganizer(){
		Agent organizer = super.createAgent(EvolvingNetworkModel.AGENT_Organizer);
		organizer.addBehavior(EvolvingNetworkModel.BEHAVIOR_PreferentialAttach);
		return organizer;
	}

	/**
	 * Node𐶐AOrganizerNodeɑ΂֌Wt^܂
	 */
	private Agent createNode(Agent organizer){
			Agent node = super.createAgent(EvolvingNetworkModel.AGENT_Node);
			organizer.addRelation(EvolvingNetworkModel.RELATION_Subject, node);
			return node;
	}
	
	/**
	 * @see org.boxed_economy.besp.bos.modelio.ModelCreator#getName()
	 */
	public String getName() {
		return "PreferentialAttachmentWorld";
	}

}
