package org.boxed_economy.evolvingnetwork.model;

import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.components.stepclock.StepClock;

/**
 * _If
 * @author iba
 */
public class RandomAttachmentWorld extends World {

	public static void main(String[] args) {
		String[] arguments =
			new String[] { "-model", RandomAttachmentWorld.class.getName()};
		BESP.main(arguments);
	}

	//
	public void initializeWorld() {

		super.initializeWorld();
		//v܂
		this.setClock(new StepClock());

		Agent organizer = this.createOrganizer();

		//NodeG[WFg𐶐܂
		for (int i = 0; i < 10; i++) {
			this.createNode(organizer);
		}

	}

	/**
	 * Organizer𐶐܂
	 */
	private Agent createOrganizer() {
		Agent organizer = this.createAgent(EvolvingNetworkModel.AGENT_Organizer);
		organizer.addBehavior(EvolvingNetworkModel.BEHAVIOR_RandomAttach);
		return organizer;
	}

	/**
	 * Node𐶐AOrganizerɂNodeɑ΂Ċ֌W܂
	 */
	private Agent createNode(Agent organizer) {
		Agent node = this.createAgent(EvolvingNetworkModel.AGENT_Node);
		organizer.addRelation(EvolvingNetworkModel.RELATION_Subject, node);
		return node;
	}

	/**
	 * @see org.boxed_economy.besp.bos.modelio.ModelCreator#getName()
	 */
	public String getName() {
		return "RandomAttachmentWorld";
	}

}
