package org.boxed_economy.evolvingnetwork.model;

import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.components.stepclock.StepClock;

/**
 * _Nf
 * @author iba
 */
public class RandomNetworkWorld extends World {

	public static int nodeNum = 20;
	
	public static void main(String[] args) {
		String[] arguments =
			new String[] { "-model", RandomNetworkWorld.class.getName()};
		BESP.main(arguments);
	}
	
	//
	public void initializeWorld() {
	
		super.initializeWorld();
		//v܂
		this.setClock(new StepClock());

		Agent organizer = this.createOrganizer();

		//NodeG[WFg𐶐܂
		for(int i=0; i<nodeNum; i++){
			this.createNode(organizer);
		}
	
	}

	private Agent createOrganizer(){
		Agent organizer = super.createAgent(EvolvingNetworkModel.AGENT_Organizer);
		organizer.addBehavior(EvolvingNetworkModel.BEHAVIOR_RandomNetworking);
		return organizer;
	}

	private Agent createNode(Agent organizer){
			Agent node = super.createAgent(EvolvingNetworkModel.AGENT_Node);
			organizer.addRelation(EvolvingNetworkModel.RELATION_Subject, node);
			return node;
	}


	/**
	 * Returns the nodeNum.
	 * @return int
	 */
	public int getNodeNum() {
		return nodeNum;
	}

	/**
	 * Sets the nodeNum.
	 * @param nodeNum The nodeNum to set
	 */
	public void setNodeNum(int nodeNum) {
		this.nodeNum = nodeNum;
	}
	
	/**
	 * WorldInitializer̂߂̃RgԂ܂B
	 */
	public String getNodeNumComment(){
		return "G[WFg(m[h)";
	}

	/**
	 * @see org.boxed_economy.besp.bos.modelio.ModelCreator#getName()
	 */
	public String getName() {
		return "RandomNetworktWorld";
	}

}
