package org.boxed_economy.evolvingnetwork.model.behavior;

import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;

import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.TimeEvent;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.GuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
* AbstractPreferentialAttachBehavior
*/
public abstract class AbstractPreferentialAttachBehavior
	extends AbstractBehavior {

	/**
	* This method automatically generated from AbstractBehavior Builder
	* Don't touch by hand
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waitingForTime =
			factory.createCompositeState("WaitingForTime");

		//actions
		Action preferentialAttachAction = new Action() {
			public void doAction() {
				preferentialAttachAction();
			}
			public String toString() {
				return "preferentialAttachAction";
			}
		};

		//guard-conditions

		//transitions
		Transition transitionWaitingForTimeToWaitingForTime =
			factory.createTransition();
		Transition transitionInitialStateToWaitingForTime =
			factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		this.addState(waitingForTime);

		//transitions setting
		transitionWaitingForTimeToWaitingForTime.setEvent(TimeEvent.class);
		transitionWaitingForTimeToWaitingForTime.addAction(
			preferentialAttachAction);

		//connection of transitions
		transitionWaitingForTimeToWaitingForTime.setSourceState(waitingForTime);
		transitionWaitingForTimeToWaitingForTime.setTargetState(waitingForTime);
		transitionInitialStateToWaitingForTime.setSourceState(initialState);
		transitionInitialStateToWaitingForTime.setTargetState(waitingForTime);

	}

	/**
	*preferentialAttachAction
	*/
	protected abstract void preferentialAttachAction();
}
