package org.boxed_economy.evolvingnetwork.model.behavior;

import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;

import org.boxed_economy.besp.model.fmfw.TimeEvent;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
* AbstractRandomNetworkingBehavior
*/
public abstract class AbstractRandomNetworkingBehavior
	extends AbstractBehavior {

	/**
	* This method automatically generated from AbstractBehavior Builder
	* Don't touch by hand
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waintingForTime =
			factory.createCompositeState("WaintingForTime");

		//actions
		Action randomNetworkingAction = new Action() {
			public void doAction() {
				randomNetworkingAction();
			}
			public String toString() {
				return "randomNetworkingAction";
			}
		};

		//guard-conditions

		//transitions
		Transition transitionInitialStateToWaintingForTime =
			factory.createTransition();
		Transition transitionWaintingForTimeToWaintingForTime =
			factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		this.addState(waintingForTime);

		//transitions setting
		transitionWaintingForTimeToWaintingForTime.setEvent(TimeEvent.class);
		transitionWaintingForTimeToWaintingForTime.addAction(
			randomNetworkingAction);

		//connection of transitions
		transitionInitialStateToWaintingForTime.setSourceState(initialState);
		transitionInitialStateToWaintingForTime.setTargetState(waintingForTime);
		transitionWaintingForTimeToWaintingForTime.setSourceState(
			waintingForTime);
		transitionWaintingForTimeToWaintingForTime.setTargetState(
			waintingForTime);

	}

	/**
	*randomNetworkingAction
	*/
	protected abstract void randomNetworkingAction();
}
