package org.boxed_economy.evolvingnetwork.model.behavior;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.evolvingnetwork.model.EvolvingNetworkModel;

/**
 * @author iba
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class PreferentialAttachBehavior
	extends AbstractPreferentialAttachBehavior {

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

	/**
	 * @see org.boxed_economy.evolvingnetwork.model.behavior.AbstractPreferentialAttachBehavior#preferentialAttachAction()
	 */
	protected void preferentialAttachAction() {
		Collection nodes =
			this.getWorld().getAgents(EvolvingNetworkModel.AGENT_Node);

		//Vm[hǉA(organizer)Ƃ̊֌W쐬
		Agent newNode = getWorld().createAgent(EvolvingNetworkModel.AGENT_Node);
		this.getAgent().addRelation(
			EvolvingNetworkModel.RELATION_Subject,
			newNode);
		Collection cumulativeLinkNumList = investigateLinkNum(nodes);

		//N̂ŁAm[h͂QKvB
		if (nodes.size() >= 2) {
			//dݕt̃_ɌԂQ̊m[hI
			Agent node1 = preferentialSelect(cumulativeLinkNumList, nodes);
			Agent node2 = null;

			do {
				node2 = preferentialSelect(cumulativeLinkNumList, nodes);
			} while (node1 == node2);

			//Vm[hƁÂQ̊m[hAoɌ		
			newNode.addRelation(EvolvingNetworkModel.RELATION_Link, node1);
			node1.addRelation(EvolvingNetworkModel.RELATION_Link, newNode);
			newNode.addRelation(EvolvingNetworkModel.RELATION_Link, node2);
			node2.addRelation(EvolvingNetworkModel.RELATION_Link, newNode);

		} else {
			throw new ModelException(
				"Model Error: You must prepare more than 1 Agent" + this);
		}

		this.testWriter();

	}

	/**
	 * ݐσÑRNVԂ܂
	 * 
	 * Ⴆ΁AAgentA = 2, AgentB = 1, AgentC = 5, AgentD = 3 ̏ꍇA
	 * Collection{ 2(=2), 3(=2+1), 8(=2+1+5), 11(=2+1+5+3)}߂lƂȂ܂
	 */
	private Collection investigateLinkNum(Collection nodes) {
		//ׂẴm[h́Aꂼ̃m[hւ̃NL^
		Iterator i = nodes.iterator();
		Collection cumulativeLinkNum = new ArrayList();
		int totalLinkNum = 0;

		while (i.hasNext()) {
			Agent agent = (Agent) i.next();
			int linkNum =
				agent.getRelations(EvolvingNetworkModel.RELATION_Link).size();
			totalLinkNum = totalLinkNum + linkNum;
			cumulativeLinkNum.add(new Integer(totalLinkNum));
		}
		return cumulativeLinkNum;
	}

	/**
	 * 葽lbg[Nm[hDIɕԂ܂
	 */
	private Agent preferentialSelect(
		Collection cumulativeLinkNumList,
		Collection nodes) {
		//ݐσN擾
		int totalLinkNum =
			((Integer) ((List) cumulativeLinkNumList)
				.get(cumulativeLinkNumList.size() - 1))
				.intValue();
		int random =
			getWorld().getRandomNumberGenerator().generate(totalLinkNum);
		Iterator i = cumulativeLinkNumList.iterator();
		Iterator j = nodes.iterator();
		while (j.hasNext()) {
			int cumulativeLinkNum = ((Integer) i.next()).intValue();
			Agent agent = (Agent) j.next();
			//ݐσN𒴂ÃG[WFgIB
			if (cumulativeLinkNum > random) {
				return agent;
			}
		}
		throw new ModelException("error at PreferentialAttachBehavior " + this);
	}

	//------------------ ȉAeXgpito do: vRɂ悤j ---------------------

	private int printTurn = 0;
	private CSVwriter writer = new CSVwriter();
	/**
	 * eXgpi폜܂j
	 * ֌WNodeɔz񂵂̂o͂܂
	 */
	private void testWriter() {
		printTurn++;
		if (printTurn == 3000) {
			StringBuffer data = new StringBuffer();
			List nums = new ArrayList();
			Iterator i =
				this
					.getWorld()
					.getAgents(EvolvingNetworkModel.AGENT_Node)
					.iterator();
			while (i.hasNext()) {
				Integer num =
					new Integer(
						((List) ((Agent) i.next())
							.getRelations(EvolvingNetworkModel.RELATION_Link))
							.size());
				nums.add(num);
			}
			Collections.sort(nums);
			Collections.reverse(nums);
			i = nums.iterator();
			while (i.hasNext()) {
				System.out.print(((Integer) i.next()).intValue() + "\n");
				data.append(((Integer) i.next()).intValue() + "\n");
			}
			printTurn = 0;
			String s = new String(data);
			this.writer.write(
				"PreferentialAttachmentWorld_Seed"
					+ getWorld().getDefaultRandomSeed()
					+ "..csv",
				s);
		} else {
		}
	}

}

class CSVwriter {

	private PrintStream stream = null;
	private String data;

	public void write(String title, String string) {
		try {
			this.stream = new PrintStream(new FileOutputStream(title));
			this.data = this.data + string;
			stream.println(this.data);
			this.stream.close();
		} catch (Exception e) {
		}
	}

}