package org.boxed_economy.evolvingnetwork.model.behavior;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.evolvingnetwork.model.EvolvingNetworkModel;

/**
 * _If̍sł
 * XebvAm[hǉÃm[hƁAłɂm[hǂꂩЂƂɃN͂܂
 * @author iba
 */
public class RandomAttachBehavior extends AbstractRandomAttachBehavior {

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

	/**
	 * VNode𐶐ANodeQɑ΂đoɊ֌W܂
	 * @see org.boxed_economy.evolvingnetwork.model.behavior.AbstractRandomAttachBehavior#randomAttachAction()
	 */
	protected void randomAttachAction() {
		List nodes =
			(List) this.getWorld().getAgents(EvolvingNetworkModel.AGENT_Node);

		//Vm[hǉA(organizer)Ƃ̊֌W쐬
		Agent newNode = getWorld().createAgent(EvolvingNetworkModel.AGENT_Node);
		this.getAgent().addRelation(
			EvolvingNetworkModel.RELATION_Subject,
			newNode);

		//N̂ŁAm[h͂QKvB
		if (nodes.size() >= 2) {
			//_ɌԂQ̊m[hI
			Agent node1 =
				((Agent) nodes
					.get(
						getWorld().getRandomNumberGenerator().generate(
							nodes.size())));
			Agent node2 = null;
			//̍ہAm[hɑ΂Ċ֌WȂ悤ɂ
			do {
				node2 =
					((Agent) nodes
						.get(
							getWorld().getRandomNumberGenerator().generate(
								nodes.size())));
			} while (node1 == node2);
			//Vm[hƁÂQ̊m[hAoɌ		
			newNode.addRelation(EvolvingNetworkModel.RELATION_Link, node1);
			node1.addRelation(EvolvingNetworkModel.RELATION_Link, newNode);
			newNode.addRelation(EvolvingNetworkModel.RELATION_Link, node2);
			node2.addRelation(EvolvingNetworkModel.RELATION_Link, newNode);

			this.testWriter();

		} else {
			throw new ModelException(
				"Model Error: You must prepare more than 1 Agent" + this);
		}

	}

	//------------------ ȉAeXgpito do: vRɂ悤j ---------------------

	private int printTurn = 0;
	private CSVwriter3 writer = new CSVwriter3();

	/**
	 * eXgpi폜܂j
	 * ֌WNodeɔz񂵂̂o͂܂
	 */
	private void testWriter() {
		printTurn++;
		if (printTurn == 3000) {
			StringBuffer data = new StringBuffer();
			List nums = new ArrayList();
			Iterator i =
				this
					.getWorld()
					.getAgents(EvolvingNetworkModel.AGENT_Node)
					.iterator();
			while (i.hasNext()) {
				Integer num =
					new Integer(
						((List) ((Agent) i.next())
							.getRelations(EvolvingNetworkModel.RELATION_Link))
							.size());
				nums.add(num);
			}
			Collections.sort(nums);
			Collections.reverse(nums);
			i = nums.iterator();
			while (i.hasNext()) {
				System.out.print(((Integer) i.next()).intValue() + "\n");
				data.append(((Integer) i.next()).intValue() + "\n");
			}
			printTurn = 0;
			String s = new String(data);
			this.writer.write(
				"RandomAttachmentWorld_Seed"
					+ getWorld().getDefaultRandomSeed()
					+ ".csv",
				s);
		} else {
		}
	}

}

class CSVwriter3 {

	private PrintStream stream = null;
	private String data;

	public void write(String title, String string) {
		try {
			this.stream = new PrintStream(new FileOutputStream(title));
			this.data = this.data + string;
			stream.println(this.data);
			this.stream.close();
		} catch (Exception e) {
		}
	}

}