package org.boxed_economy.evolvingnetwork.model.behavior;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.evolvingnetwork.model.EvolvingNetworkModel;
import org.boxed_economy.evolvingnetwork.model.RandomNetworkWorld;

/**
 * _lbg[Nf̍sł
 * ֌WNodeG[WFgQ_ɑIŁAN͂̂𒇉܂
 * @author iba
 */
public class RandomNetworkingBehavior
	extends AbstractRandomNetworkingBehavior {

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

	/**
	 * @see org.boxed_economy.evolvingnetwork.model.behavior.AbstractRandomNetworkingBehavior#randomNetworkingAction()
	 */
	protected void randomNetworkingAction() {
		List nodes =
			(List) this.getWorld().getAgents(EvolvingNetworkModel.AGENT_Node);

		//N̂ŁAm[h͂QKvB
		if (nodes.size() >= 2) {
			//_ɌԂQ̊m[hI
			Agent node1 =
				((Agent) nodes
					.get(
						getWorld().getRandomNumberGenerator().generate(
							nodes.size())));
			Agent node2;

			do {
				node2 =
					((Agent) nodes
						.get(
							getWorld().getRandomNumberGenerator().generate(
								nodes.size())));
			} while (node1 == node2);

			//Vm[hƁÂQ̊m[hAoɌ		
			node1.addRelation(EvolvingNetworkModel.RELATION_Link, node2);
			node2.addRelation(EvolvingNetworkModel.RELATION_Link, node1);

		} else {
			throw new ModelException("Model Error: You must prepare more than 1 Agent");
		}

		//ȉANX^[̋K݂͂邽߂̏
		nodes =
			(List) this.getWorld().getAgents(EvolvingNetworkModel.AGENT_Node);
		this.printClusterCondition(nodes);
	}

	//--------- ȉAf[^̎̂߂̏ito do : vR邱Ɓj ---------

	private CSVwriter2 data = new CSVwriter2();

	private void printClusterCondition(List nodes) {
		List clusters = this.getClusters(nodes);

		//NX^[f[^肵܂
		List data = new ArrayList();
		Iterator clustersIterator = clusters.iterator();
		while (clustersIterator.hasNext()) {
			Cluster c = (Cluster) clustersIterator.next();
			data.add(new Integer(c.size()));
		}
		//Ƀ\[g܂
		Collections.sort(data);
		Collections.reverse(data);

		StringBuffer dataBuffer = new StringBuffer();
		Iterator dataIterator = data.iterator();
		while (dataIterator.hasNext()) {
			//System.out.print(((Integer) dataIterator.next()).intValue() + " ");
			dataBuffer.append(((Integer) dataIterator.next()).intValue() + ",");
		}
		//System.out.print("\n");
		dataBuffer.append("\n");
		String dataString = new String(dataBuffer);
		this.data.write(
			"RandomNetworkingWorld_Seed"
				+ getWorld().getDefaultRandomSeed()
				+ "_Node"
				+ RandomNetworkWorld.nodeNum
				+ ".csv",
			dataString);
	}

	/**
	 * NX^[Ԃ܂
	 */
	private List getClusters(List nodes) {
		//NX^[Q
		List clusters = new ArrayList();
		Iterator nodesIterator = nodes.iterator();
		while (nodesIterator.hasNext()) {
			Agent agent = (Agent) nodesIterator.next();
			//NX^[Q̏ꍇAVNX^[쐬܂
			if (clusters.isEmpty()) {
				clusters.add(new Cluster(agent));
			}
			//NX^[Q݂ꍇÃNX^[Qagent܂܂Ă邩ǂ𔻒肵܂
			else {
				boolean isExist = false;
				Iterator clustersIterator = clusters.iterator();
				while (clustersIterator.hasNext()) {
					Cluster cluster = (Cluster) clustersIterator.next();
					//̃NX^[Ɋ܂܂ꍇÃNX^[ɒǉbreak܂
					if (cluster.containsKey(agent)) {
						cluster.put(agent);
						isExist = true;
						break;
					}
				}
				if (!isExist) {
					//̃NX^[SĂɊ܂܂ȂꍇAVNX^[쐬܂
					clusters.add(new Cluster(agent));
				}
			}
		}
		return clusters;
	}

}

/**
 * NX^[ł
 * LinkedHashMapƂAgent܂
 */
class Cluster {

	private LinkedHashMap agents = new LinkedHashMap();

	public Cluster(Agent agent) {
		this.put(agent);
	}

	public boolean containsKey(Agent agent) {
		return this.agents.containsKey(agent);
	}

	public int size() {
		return this.agents.keySet().size();
	}

	/**
	 * AgentǉƓɁA
	 * Agent̂RelationAgentRelationAgentAAAƁASĒǉ܂
	 */
	public void put(Agent agent) {
		this.agents.put(agent, agent);
		Iterator relationIterator =
			agent.getRelations(EvolvingNetworkModel.RELATION_Link).iterator();
		while (relationIterator.hasNext()) {
			Relation relation = (Relation) relationIterator.next();
			Agent target = relation.getTarget();
			if (!this.agents.containsKey(target)) {
				//֌WAgent܂܂ĂȂꍇAput܂
				this.put(target);
			} else {
				//֌WAgent܂܂ĂꍇAput܂
			}
		}
	}

}

class CSVwriter2 {

	private PrintStream stream = null;
	private String data;

	public void write(String title, String string) {
		try {
			this.stream = new PrintStream(new FileOutputStream(title));
			this.data = this.data + string;
			stream.println(this.data);
			this.stream.close();
		} catch (Exception e) {
		}
	}

}