/*
 * ElementChoosePanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.elementchooser;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.WindowConstants;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 * @author macchan
 * @version $Id: ElementChoosePanel.java,v 1.2 2003/06/03 04:50:46 macchan Exp $
 */
public class ElementChoosePanel extends JPanel {

	/*********************************
	 * Instance Variables
	 *********************************/
	
	private List elements = null;

	private ListPanel addedElementsPanel = new ListPanel();
	private ListPanel removedElementsPanel = new ListPanel();

	private JButton addButton = new JButton("ADD >>");
	private JButton removeButton = new JButton("<< REMOVE");

	private String removedMessage = "Removed Elements";
	private String addedMessage = "Added Elements";

	/*********************************
	 * Constructors
	 *********************************/

	/**
	 * Constructor for ElementChoosePanel.
	 */
	public ElementChoosePanel() {
		this(new ArrayList());
	}

	/**
	 * Constructor for ElementChoosePanel.
	 */
	public ElementChoosePanel(List elements) {
		this(elements, new ArrayList());
	}

	/**
	 * Constructor for ElementChoosePanel.
	 */
	public ElementChoosePanel(List elements, List addedElements) {
		this(elements, addedElements, "", "");
	}

	/**
	 * Constructor for ElementChoosePanel.
	 */
	public ElementChoosePanel(String removedMessage, String addedMessage) {
		this(new ArrayList(), new ArrayList(), removedMessage, addedMessage);
	}

	/**
	 * Constructor for ElementChoosePanel.
	 */
	public ElementChoosePanel(
		List elements,
		List addedElements,
		String removedMessage,
		String addedMessage) {

		this.removedMessage = removedMessage;
		this.addedMessage = addedMessage;

		this.setElements(elements, addedElements);
		this.initialize();
		buttonStateUpdated();
	}

	/*********************************
	 * Initializer
	 *********************************/

	/**
	 * Initialize this Panel
	 */
	private void initialize() {
		//initialize this component
		this.setPreferredSize(new Dimension(600, 260));

		//initialize components
		JPanel addRemovePanel = createAddRemovePanel();

		//initialize listPanels
		addedElementsPanel.setPreferredSize(new Dimension(200, 200));
		addedElementsPanel
			.getJList()
			.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent e) {
				buttonStateUpdated();
			}
		});
		removedElementsPanel.setPreferredSize(new Dimension(200, 200));
		removedElementsPanel
			.getJList()
			.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent e) {
				buttonStateUpdated();
			}
		});

		//add components
		this.add(new TitleDecorationPanel(removedMessage, removedElementsPanel));
		this.add(addRemovePanel);
		this.add(new TitleDecorationPanel(addedMessage, addedElementsPanel));
	}

	private JPanel createAddRemovePanel() {
		//addremovePanel
		JPanel addremovePanel = new VerticalLayoutPanel();

		//addButton
		addButton.setPreferredSize(new Dimension(80, 27));
		addButton.setMargin(new Insets(2, 2, 2, 2));
		addButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				add();
			}
		});

		//removeButton
		removeButton.setPreferredSize(new Dimension(80, 27));
		removeButton.setMargin(new Insets(2, 2, 2, 2));
		removeButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				remove();
			}
		});

		//add components
		addremovePanel.add(addButton);
		addremovePanel.add(removeButton);

		return addremovePanel;
	}

	/*********************************
	 * Up and Down
	 *********************************/

	private void add() {
		move(removedElementsPanel, addedElementsPanel);
	}

	private void remove() {
		move(addedElementsPanel, removedElementsPanel);
	}

	private void move(ListPanel source, ListPanel target) {
		int[] selectedIndices = source.getJList().getSelectedIndices();
		if (selectedIndices.length > 0) {
			moveElements(source, target, selectedIndices);
		}
		buttonStateUpdated();
	}

	private void moveElements(
		ListPanel source,
		ListPanel target,
		int[] indices) {

		if (this.elements == null) {
			throw new RuntimeException("elements have not been set");
		}

		List moveElements = this.removeAll(source.getList(), indices);
		if (!this.elements.containsAll(moveElements)) {
			throw new RuntimeException("illegal moveElements");
		}
		source.refresh();

		target.getList().addAll(moveElements);
		target.refresh();
	}

	private List removeAll(List list, int[] indices) {
		List removedElements = new ArrayList();

		int removeCount = 0;
		int len = indices.length;
		for (int i = 0; i < len; i++) {
			removedElements.add(list.remove(indices[i - removeCount]));
			removeCount++;
		}
		return removedElements;
	}

	/*********************************
	 * public interface
	 *********************************/

	public List getAddedElements() {
		return this.addedElementsPanel.getList();
	}

	public List getRemovedElements() {
		return this.removedElementsPanel.getList();
	}

	public List getElements() {
		return this.elements;
	}

	public void setElements(List elements, List addElements) {
		this.setElements(elements);
		this.addElements(addElements);
	}

	public void setElements(List elements) {
		//폜		
		if (this.elements != null) {
			this.addedElementsPanel.getList().clear();
			this.addedElementsPanel.refresh();
			this.removedElementsPanel.getList().clear();
			this.removedElementsPanel.refresh();
		}

		//ݒ
		this.elements = elements;

		//r[ݒ			
		if (this.elements != null) {
			this.removedElementsPanel.getList().addAll(elements);
			this.removedElementsPanel.refresh();
		}
	}

	private void addElements(List addElements) {
		int[] indices = getIndices(elements, addElements);
		moveElements(removedElementsPanel, addedElementsPanel, indices);
	}

	private int[] getIndices(List all, List elements) {
		//O
		int len = all.size();

		//𑪂
		int amount = 0;
		for (int i = 0; i < len; i++) {
			if (elements.contains(all.get(i))) {
				amount++;
			}
		}

		//Ԓnz쐬
		int[] indices = new int[amount];
		int counter = 0;
		for (int i = 0; i < len; i++) {
			if (elements.contains(all.get(i))) {
				indices[counter] = i;
				counter++;
			}
		}

		return indices;
	}

	/*******************************
	 * state management
	 *******************************/

	public void buttonStateUpdated() {
		{ //add button
			int selectedIndex = removedElementsPanel.getJList().getSelectedIndex();
			if (selectedIndex >= 0
				&& selectedIndex < removedElementsPanel.getList().size()) {
				this.addButton.setEnabled(true);
			}
			else {
				this.addButton.setEnabled(false);
			}
		}

		{ //remove button
			int selectedIndex = addedElementsPanel.getJList().getSelectedIndex();
			if (selectedIndex >= 0
				&& selectedIndex < addedElementsPanel.getList().size()) {
				this.removeButton.setEnabled(true);
			}
			else {
				this.removeButton.setEnabled(false);
			}
		}
	}

	/*******************************
	 * test code
	 *******************************/

	public static void main(String args[]) {
		JFrame frame = new JFrame();
		frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		frame.setSize(600, 320);
		ElementChoosePanel listPanel = new ElementChoosePanel("added", "removed");
		frame.getContentPane().add(new TitleDecorationPanel("Hello!", listPanel));
		frame.show();
		List list = new ArrayList();
		List list2 = new ArrayList();
		list.add("");
		list.add("");
		list.add("");
		list.add("");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list2.add("");
		list2.add("");
		list2.add("");
		//		list2.add("̂ȂǂȂł傤H");		
		listPanel.setElements(list, list2);
	}

}
