/*
 * ElementChooser.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.elementchooser;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.WindowConstants;

/**
 * @author macchan
 * @version $Id: ElementChooser.java,v 1.1 2003/06/03 04:49:22 macchan Exp $
 */
public class ElementChooser {

	/*************************************
	 * Static
	 *************************************/

	/**
	 * create and open type chooser panel
	 * (modal and block)
	 */
	public static List open(
		Frame owner,
		List elements,
		List addedElements,
		String title,
		String instruction,
		String removedMessage,
		String addedMessage) {

		ElementChoosePanel chooser =
			new ElementChoosePanel(
				elements,
				addedElements,
				removedMessage,
				addedMessage);

		return open(owner, chooser, title, instruction);
	}

	/**
	 * open type chooser panel
	 * (modal and block)
	 */
	public static List open(
		Frame owner,
		ElementChoosePanel chooser,
		String title,
		String instruction) {

		//O
		JPanel titledChooser = new TitleDecorationPanel(instruction, chooser);

		//\
		int result =
			JOptionPane.showConfirmDialog(
				owner,
				titledChooser,
				title,
				JOptionPane.OK_CANCEL_OPTION,
				JOptionPane.PLAIN_MESSAGE,
				null);

		//㏈
		if (result == JOptionPane.OK_OPTION) {
			return chooser.getAddedElements();
		}
		else {
			return null;
		}
	}

	/*******************************
	 * test code
	 *******************************/

	public static void main(String args[]) {
		final JFrame frame = new JFrame();
		frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		frame.setSize(300, 300);

		JButton button = new JButton("open");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				showDialog(frame);
			}
		});
		frame.getContentPane().add(button);

		frame.show();
	}

	public static void showDialog(Frame frame) {
		List list = new ArrayList();
		List list2 = new ArrayList();
		list.add("");
		list.add("");
		list.add("");
		list.add("");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list2.add("");
		list2.add("");
		list2.add("");

		List added =
			ElementChooser.open(
				frame,
				list,
				list2,
				"ElementChooser",
				"Please, add elements",
				"Added Elements",
				"Removed Elements");
		System.out.println(added);
	}

}
