/*
 * ListModel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.elementchooser;

import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractListModel;

/**
 * @author macchan
 * @version $Id: ListModel.java,v 1.2 2003/06/03 04:52:56 macchan Exp $
 */
public class ListModel extends AbstractListModel {

	/*********************************
	 * Instance Variables
	 *********************************/
	
	private List list = new ArrayList();

	/*********************************
	 * Constructors
	 *********************************/

	/**
	 * Constructor for ListModel.
	 */
	public ListModel() {
		this(new ArrayList());
	}

	/**
	 * Constructor for ListModel.
	 */
	public ListModel(List list) {
		this.setList(list);
	}

	/*********************************
	 * implements for ListModel
	 *********************************/

	/**
	 * @see javax.swing.ListModel#getElementAt(int)
	 */
	public Object getElementAt(int index) {
		return this.list.get(index);
	}

	/**
	 * @see javax.swing.ListModel#getSize()
	 */
	public int getSize() {
		return this.list.size();
	}

	/*********************************
	 * updater
	 *********************************/

	/**
	 * update this model's view
	 */
	public void update() {
		this.fireContentsChanged(this, 0, 100);
	}

	/*********************************
	 * getter & setter
	 *********************************/

	/**
	 * Returns the model.
	 * @return List
	 */
	public List getList() {
		return list;
	}

	/**
	 * Sets the model.
	 * @param model The model to set
	 */
	public void setList(List model) {
		this.list = model;
		update();
	}

}
