/*
 * ListPanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.elementchooser;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.WindowConstants;

/**
 * @author macchan
 * @version $Id: ListPanel.java,v 1.2 2003/06/03 04:52:56 macchan Exp $
 */
public class ListPanel extends JPanel {

	/*********************************
	 * Instance Variables
	 *********************************/
	
	private ListModel model = null;
	private JList jList = new JList();

	/*********************************
	 * Constructors
	 *********************************/

	/**
	 * Constructor for ListPanel.
	 */
	public ListPanel() {
		this(new ArrayList());
	}

	/**
	 * Constructor for ListPanel.
	 */
	public ListPanel(List list) {
		this.model = new ListModel(list);
		this.initialize();
	}

	/*********************************
	 * Initializer
	 *********************************/

	/**
	 * Initialize this Panel
	 */
	private void initialize() {
		//initialize layout
		this.setLayout(new BorderLayout());

		//create components
		JScrollPane scroll = new JScrollPane();

		//initialize components
		jList.setModel(model);

		//add components
		scroll.getViewport().add(jList);
		this.add(scroll, BorderLayout.CENTER);
	}

	/*********************************
	 * Updater
	 *********************************/

	/**
	 * Update List
	 */
	public void refresh() {
		this.model.update();
		initializeSelection();
	}

	/**
	 * initialize the selection
	 */
	private void initializeSelection() {
		this.jList.setSelectedIndices(new int[0]);
	}

	/*******************************
	 * getter and setter
	 *******************************/

	/**
	 * Returns the list.
	 * @return List
	 */
	public List getList() {
		return this.model.getList();
	}

	/**
	 * Sets the list.
	 * @param list The list to set
	 */
	public void setList(List list) {
		this.model.setList(list);
		initializeSelection();
	}

	/**
	 * Returns the jList.
	 * @return JList
	 */
	public JList getJList() {
		return jList;
	}

	/**
	 * Returns the model.
	 * @return ListModel
	 */
	public ListModel getModel() {
		return model;
	}

	/*******************************
	 * test code
	 *******************************/

	public static void main(String args[]) {
		JFrame frame = new JFrame();
		frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		frame.setSize(300, 300);

		ListPanel listPanel = new ListPanel();
		frame.getContentPane().add(listPanel);
		frame.show();

		List list = new ArrayList();
		list.add("");
		list.add("");
		list.add("");
		listPanel.setList(list);

		list.add("");
		listPanel.refresh();

	}

}
