/*
 * TitleDecorationPanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.elementchooser;

import java.awt.BorderLayout;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * @author macchan
 * @version $Id: TitleDecorationPanel.java,v 1.1 2003/06/03 04:49:22 macchan Exp $
 */
public class TitleDecorationPanel extends JPanel {

	/*********************************
	 * Constructors
	 *********************************/

	/**
	 * Constructor for TitleDecorationPanel.
	 */
	public TitleDecorationPanel(String title, JComponent component) {

		//initialize this component
		this.setLayout(new BorderLayout());

		//initialize components
		JPanel northPanel = new JPanel();
		JPanel centerPanel = new JPanel();
		centerPanel.setLayout(new BorderLayout());
		JLabel titleLabel = new JLabel(title);

		//add components
		northPanel.add(titleLabel);
		centerPanel.add(component);
		this.add(northPanel, BorderLayout.NORTH);
		this.add(centerPanel, BorderLayout.CENTER);

	}

}
