/*
 * UpDownListPanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.elementchooser;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.WindowConstants;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 * @author macchan
 * @version $Id: UpDownListPanel.java,v 1.2 2003/06/03 04:52:56 macchan Exp $
 */
public class UpDownListPanel extends JPanel {

	/*********************************
	 * Instance Variables
	 *********************************/
	
	private ListPanel listPanel = null;

	private JButton upButton = new JButton("UP");
	private JButton downButton = new JButton("DN");

	/*********************************
	 * Constructors
	 *********************************/

	/**
	 * Constructor for UpDownListPanel.
	 */
	public UpDownListPanel() {
		this(new ArrayList());
	}

	/**
	 * Constructor for ListPanel.
	 */
	public UpDownListPanel(List list) {
		this.listPanel = new ListPanel(list);
		this.initialize();
		this.buttonStateUpdated();
	}

	/*********************************
	 * Initializer
	 *********************************/

	/**
	 * Initialize this Panel
	 */
	private void initialize() {
		//initialize layout
		this.setLayout(new BorderLayout());

		//initialize components
		JPanel updownPanel = createUpDownPanel();
		listPanel.getJList().addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent e) {
				buttonStateUpdated();
			}
		});

		//add components
		this.add(listPanel, BorderLayout.CENTER);
		this.add(updownPanel, BorderLayout.EAST);
	}

	private JPanel createUpDownPanel() {
		//updownPanel
		JPanel updownPanel = new VerticalLayoutPanel();

		//upButton
		upButton.setPreferredSize(new Dimension(30, 27));
		upButton.setMargin(new Insets(2, 2, 2, 2));
		upButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				up();
			}
		});

		//downButton
		downButton.setPreferredSize(new Dimension(30, 27));
		downButton.setMargin(new Insets(2, 2, 2, 2));
		downButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				down();
			}
		});

		//add components
		updownPanel.add(upButton);
		updownPanel.add(downButton);

		return updownPanel;
	}

	/*********************************
	 * Up and Down
	 *********************************/

	private void up() {
		move(-1);
	}

	private void down() {
		move(1);
	}

	private void move(int move) {
		JList jList = listPanel.getJList();
		List list = listPanel.getList();
		int selectedIndex = jList.getSelectedIndex();
		int movedIndex = selectedIndex + move;

		Object object = list.remove(selectedIndex);
		list.add(movedIndex, object);
		listPanel.refresh();
		jList.setSelectedIndex(movedIndex);
	}

	/*******************************
	 * getter and setter
	 *******************************/

	/**
	 * Returns the listPanel.
	 * @return ListPanel
	 */
	public ListPanel getListPanel() {
		return listPanel;
	}

	/*******************************
	 * state management
	 *******************************/
	public void buttonStateUpdated() {
		int selectedIndex = listPanel.getJList().getSelectedIndex();

		//up button
		if (selectedIndex > 0 && selectedIndex <= listPanel.getList().size() - 1) {
			this.upButton.setEnabled(true);
		}
		else {
			this.upButton.setEnabled(false);
		}

		//down button
		if (selectedIndex >= 0 && selectedIndex < listPanel.getList().size() - 1) {
			this.downButton.setEnabled(true);
		}
		else {
			this.downButton.setEnabled(false);
		}
	}

	/*******************************
	 * test code
	 *******************************/

	public static void main(String args[]) {
		JFrame frame = new JFrame();
		frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		frame.setSize(300, 300);

		UpDownListPanel listPanel = new UpDownListPanel();
		frame.getContentPane().add(listPanel);
		frame.show();

		List list = new ArrayList();
		list.add("");
		list.add("");
		list.add("");

		listPanel.getListPanel().setList(list);
		list.add("");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		list.add("̂ȂǂȂł傤H");
		listPanel.getListPanel().refresh();
	}

}
