/*
 * VerticalLayoutPanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.elementchooser;

import java.awt.Component;
import java.awt.FlowLayout;

import javax.swing.JPanel;

import sun.awt.OrientableFlowLayout;

/**
 * @author macchan
 * @version $Id: VerticalLayoutPanel.java,v 1.1 2003/06/03 04:49:22 macchan Exp $
 */
public class VerticalLayoutPanel extends JPanel {

	/*********************************
	 * Constructors
	 *********************************/

	/**
	 * Constructor for VerticalLayoutPanel.
	 */
	public VerticalLayoutPanel() {
		this.setLayout(new OrientableFlowLayout(OrientableFlowLayout.VERTICAL));
	}

	/*********************************
	 * Special Override Methods
	 *********************************/

	protected void addImpl(Component comp, Object constraints, int index) {
		if (!(comp instanceof JPanel)) {
			JPanel panel = new JPanel();
			panel.setLayout(new FlowLayout(FlowLayout.CENTER, 0, 0));
			panel.add(comp);
			comp = panel;
		}
		super.addImpl(comp, constraints, index);
	}

}
