/*
 * AgentNode.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.relationview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

import javax.swing.JPanel;

import org.boxed_economy.besp.model.fmfw.Agent;

/**
 * @author macchan
 * @version $Id: AgentNode.java,v 1.1 2003/06/03 04:49:22 macchan Exp $
 */
public class AgentNode extends JPanel {

	/*******************************************
	 * Constant
	 *******************************************/

	private static final Dimension DEFAULT_SIZE = new Dimension(10, 10);
	private static final Point DEFAULT_LABEL_LOCATION = new Point(10, 10);

	/*******************************************
	 * Instance Variables
	 *******************************************/

	private Point labelLocation = DEFAULT_LABEL_LOCATION;
	private Agent agent = null;

	/*******************************************
	 * Constructors
	 *******************************************/

	/**
	 * Constructor
	 */
	public AgentNode(Agent agent) {
		this.agent = agent;
		initialize();
	}

	/*******************************************
	 * Initializers
	 *******************************************/

	/**
	 * initialize this object
	 */
	private void initialize() {
		this.setSize(DEFAULT_SIZE);

		this.addMouseMotionListener(new MouseMotionListener() {

			public void mouseMoved(MouseEvent e) {
			}

			public void mouseDragged(MouseEvent e) {
				int x = AgentNode.this.getX();
				int y = AgentNode.this.getY();
				int newX = x + (e.getX() - AgentNode.this.getWidth() / 2);
				int newY = y + (e.getY() - AgentNode.this.getHeight() / 2);
				AgentNode.this.setLocation(newX, newY);
				AgentNode.this.getParent().repaint();
			}

		});
	}

	/*******************************************
	 * paint
	 *******************************************/

	/**
	 * @see javax.swing.JComponent#paintComponent(Graphics)
	 */
	protected void paintComponent(Graphics g) {
		g.setColor(Color.black);
		g.fillOval(0, 0, getWidth(), getHeight());
	}

	/*******************************************
	 * point getter
	 *******************************************/

	/**
	 * calculate the center of this object
	 */
	public Point getCenter() {
		return new Point(getX() + getWidth() / 2, getY() + getHeight() / 2);
	}

	/**
	 * calculate the LeftUpper of this object
	 */
	public Point getLeftUpper() {
		return new Point(getX(), getY());
	}

	/**
	 * calculate the LeftLower of this object
	 */
	public Point getLeftLower() {
		return new Point(getX(), getY() + getHeight());
	}

	/**
	 * calculate the RightUpper of this object
	 */
	public Point getRightUpper() {
		return new Point(getX() + getWidth(), getY());
	}

	/**
	 * calculate the RightLower of this object
	 */
	public Point getRightLower() {
		return new Point(getX() + getWidth(), getY() + getHeight());
	}

	/*******************************************
	 * getter & setter 
	 *******************************************/

	/**
	 * Returns the labelPoint.
	 * @return Point
	 */
	public Point getLabelLocation() {
		return labelLocation;
	}

	/**
	 * Sets the labelPoint.
	 * @param labelPoint The labelPoint to set
	 */
	public void setLabelLocation(Point labelPoint) {
		this.labelLocation = labelPoint;
	}

	/**
	 * Returns the agent.
	 * @return Agent
	 */
	public Agent getAgent() {
		return agent;
	}

}
