/*
 * RelationViewer.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.relationview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.besp.presentation.gui.AbstractInternalFrameComponent;
import org.boxed_economy.components.relationview.canvas.AbstractRelationViewCanvas;
import org.boxed_economy.components.relationview.canvas.CircleRelationViewCanvas;
import org.boxed_economy.components.relationview.canvas.CollaborationGraphCanvas;
import org.boxed_economy.components.relationview.canvas.LayerRelationViewCanvas;
import org.boxed_economy.components.relationview.canvas.RandomRelationViewCanvas;

/**
 * @author macchan
 * @version $Id: RelationViewer.java,v 1.5 2003/07/11 09:56:58 box Exp $
 */
public class RelationViewer
	extends AbstractInternalFrameComponent
	implements ModelContainerListener, UpdateClockListener, UpdateViewModelListener, SimulationStateListener {

	/*********************************
	 * Instance Variables
	 *********************************/

	private JTabbedPane tabbedPane = new JTabbedPane();
	private List canvases = new ArrayList();

	private TypeSelectionPanel agentTypeSelection = null;
	private TypeSelectionPanel relationTypeSelection = null;

	/************************************
	 * Constructors
	 ************************************/

	/**
	 * Constructor for RelationViewer2.
	 */
	public RelationViewer() {
		super();
	}

	/************************************
	 * Initializers
	 ************************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#initialize()
	 */
	public void initialize() {
		this.initializeComponents();
		this.addUpdateClockListener(this);
	}

	private void initializeComponents() {
		//this
		this.getContentPane().setLayout(new BorderLayout());
		this.setSize(new Dimension(600,400));

		//components
		JPanel selectionPanel = createTypeSelectionPanels();
		this.initializeCanvases();
		

		//add
		this.getContentPane().add(selectionPanel, BorderLayout.WEST);
		this.getContentPane().add(tabbedPane, BorderLayout.CENTER);
	}

	private JPanel createTypeSelectionPanels() {
		//panel
		JPanel panel = new JPanel();
		panel.setLayout(new GridLayout(2, 0));

		//AgentType panel
		Collection agentTypes =
			this.getPresentationContainer().getModelContainer().getAgentTypes();
		this.agentTypeSelection =
			new TypeSelectionPanel(
				getMainFrame(),
				new ArrayList(agentTypes),
				"AgentType");
		this.agentTypeSelection.addUpdateViewModelListener(this);

		//RelationType panel		
		Collection relationTypes =
			this.getPresentationContainer().getModelContainer().getRelationTypes();
		this.relationTypeSelection =
			new TypeSelectionPanel(
				getMainFrame(),
				new ArrayList(relationTypes),
				"RelationType");
		this.relationTypeSelection.addUpdateViewModelListener(this);

		//add
		panel.add(agentTypeSelection);
		panel.add(relationTypeSelection);

		return panel;
	}

	private void initializeCanvases() {
		//circle
		CircleRelationViewCanvas circle =
			new CircleRelationViewCanvas(agentTypeSelection, relationTypeSelection);
		circle.setEnabled(false);
		this.tabbedPane.add("Circle", circle);

		//layer
		LayerRelationViewCanvas layer =
			new LayerRelationViewCanvas(agentTypeSelection, relationTypeSelection);
		layer.setEnabled(false);
		this.tabbedPane.add("Layer", layer);

		//Random
		RandomRelationViewCanvas random =
			new RandomRelationViewCanvas(agentTypeSelection, relationTypeSelection);
		random.setEnabled(false);
		this.tabbedPane.add("Random", random);
				
		//Collaboration Graph
		CollaborationGraphCanvas graph =
			new CollaborationGraphCanvas(agentTypeSelection, relationTypeSelection);
		graph.setEnabled(false);
		this.tabbedPane.add("Graph", graph);
	}

	/************************************
	 * Finalizer
	 ************************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#terminate()
	 */
	public void terminate() {
		this.removeUpdateClockListener(this);
	}

	/************************************
	 * model state management
	 ************************************/

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldClose(ModelContainerEvent)
	 */
	public void prepareWorldClose(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldOpen(ModelContainerEvent)
	 */
	public void prepareWorldOpen(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldClosed(ModelContainerEvent)
	 */
	public void worldClosed(ModelContainerEvent ev) {
		Component[] components = this.tabbedPane.getComponents();
		for (int i = 0; i < components.length; i++) {
			AbstractRelationViewCanvas canvas =
				(AbstractRelationViewCanvas) components[i];
			canvas.setEnabled(false);
			canvas.setWorld(null);
		}
	}




	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldOpened(ModelContainerEvent)
	 */
	public void worldOpened(ModelContainerEvent ev) {
		Component[] components = this.tabbedPane.getComponents();
		for (int i = 0; i < components.length; i++) {
			AbstractRelationViewCanvas canvas =
				(AbstractRelationViewCanvas) components[i];
			canvas.setEnabled(true);
			canvas.setWorld(getWorld());
		}
	}

	/************************************
	 * implement for UpdateViewModelListener
	 ************************************/

	/**
	 * @see org.boxed_economy.components.relationviewer.UpdateViewModelListener#update()
	 */
	public void viewModelUpdated() {
		Component[] components = this.tabbedPane.getComponents();
		for (int i = 0; i < components.length; i++) {
			AbstractRelationViewCanvas canvas =
				(AbstractRelationViewCanvas) components[i];
			canvas.updateAll();
		}
	}

	/************************************
	 * implement for UpdateClockListener
	 ************************************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateClockListener#clockGained(UpdateClockEvent)
	 */
	public void clockGained(UpdateClockEvent e) {
		((AbstractRelationViewCanvas) tabbedPane.getSelectedComponent())
			.updateAll();
	}


	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStarted(SimulationStateEvent)
	 */
	public void simulationStarted(SimulationStateEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopped(SimulationStateEvent)
	 */
	public void simulationStopped(SimulationStateEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopping(SimulationStateEvent)
	 */
	public void simulationStopping(SimulationStateEvent ev) {
		repaint();
	}

}
