/*
 * CircleRelationViewCanvas.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.relationview.canvas;

import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

import javax.swing.SwingUtilities;

import org.boxed_economy.components.relationview.AgentNode;
import org.boxed_economy.components.relationview.TypeSelection;


/**
 * @author macchan
 * @version $Id: CircleRelationViewCanvas.java,v 1.1 2003/06/03 04:49:22 macchan Exp $
 */
public class CircleRelationViewCanvas extends AbstractRelationViewCanvas {

	/*******************************************
	 * Constant
	 *******************************************/

	private static final int CHAR_WIDTH = 6;
	private static final int CHAR_HEIGHT = 6;

	/*******************************************
	 * Instance Variables
	 *******************************************/

	private int margin = 50;

	/*******************************************
	 * Constructors
	 *******************************************/

	/**
	 * Constructor for CircleRelationViewCanvas.
	 * @param agentTypes
	 * @param relationTypes
	 */
	public CircleRelationViewCanvas(
		TypeSelection agentTypes,
		TypeSelection relationTypes) {
		super(agentTypes, relationTypes);
	}

	/*******************************************
	 * layouting
	 *******************************************/

	/**
	 * re-layout all nodes
	 * re-layout circle
	 */
	protected void layoutNodes() {
		List nodes = new ArrayList(super.getOrderedAllNodes());

		int width = this.getWidth();
		int height = this.getHeight();

		int amount = nodes.size(); // m[h
		int radius = ((width > height) ? (height / 2) : (width / 2)) - margin;
		//a
		Point center = new Point(width / 2, height / 2); // ~̒S

		for (int i = 0; i < amount; i++) {
			AgentNode node = (AgentNode) nodes.get(i);

			//agent location
			Point location =
				calculateCircumferentialLocation(center, radius, amount, i, node);
			node.setLocation(location);

			//label location
			Point labelLocation = calculateCircumferentialLabelLocation(center, node);
			node.setLabelLocation(labelLocation);
		}
	}

	/**
	 * calculate the point for each node
	 */
	private Point calculateCircumferentialLocation(
		Point center,
		int radius,
		int amount,
		int count,
		AgentNode node) {

		double radian = Math.PI * 2 * ((double) (count % amount) / amount); //px
		int x =
			(int) ((Math.sin(radian) * radius) + center.x) - (node.getWidth() / 2);
		int y =
			(int) ((-Math.cos(radian) * radius) + center.y) - (node.getHeight() / 2);

		return new Point(x, y);
	}

	/**
	 * calculate suitable point for each node's label
	 * This code was written by Iba
	 * SیꂼŁA̔zuꏊ肷
	 */
	private Point calculateCircumferentialLabelLocation(
		Point center,
		AgentNode node) {

		String text = node.getAgent().getType().getName();
		int x;
		int y;

		//xW
		if (node.getX() >= center.x) { //Ȅꍇ
			x = node.getWidth();
		}
		else { //̏ꍇ
			x = 0;
			{ //̏ꍇA̒Ɉʒu炷
				x = x - computeStringLength(text);
			}
		}

		//yW
		if (node.getY() <= center.y) { //㑤̏ꍇ
			y = 0;
		}
		else { //̏ꍇ
			y = node.getHeight();
			{ //̏ꍇȀcɂ炷

				y = y + CHAR_HEIGHT;

			}
		}

		return new Point(x, y);
	}

	/*******************************************
	 * utility
	 *******************************************/

	private int computeStringLength(String text) {
		Graphics g = getGraphics();
		if (g == null) {
			return text.length() * CHAR_WIDTH;
		}
		else {
			return SwingUtilities.computeStringWidth(g.getFontMetrics(), text);
		}
	}

	/*******************************************
	 * test code
	 *******************************************/

	public static void main(String args[]) {
		CircleRelationViewCanvas canvas = new CircleRelationViewCanvas(null, null);
		int radius = 100;
		int amount = 8;
		int nodeSize = 10;
		Point center = new Point(100, 100);

		for (int i = 0; i < amount; i++) {
			Point p =
				canvas.calculateCircumferentialLocation(
					center,
					radius,
					amount,
					i,
					new AgentNode(null));
			System.out.println("p.x=" + p.x + " p.y=" + p.y);
		}
	}

}