/*
 * CircleRelationViewCanvas.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.relationview.canvas;

import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.RelationType;
import org.boxed_economy.components.relationview.AgentNode;
import org.boxed_economy.components.relationview.TypeSelection;

/**
 * @author macchan
 * @version $Id: CollaborationGraphCanvas.java,v 1.1 2003/07/11 09:56:49 box Exp $
 */
public class CollaborationGraphCanvas extends AbstractRelationViewCanvas {

	/*******************************************
	 * Constant
	 *******************************************/

	private static final int CHAR_WIDTH = 6;
	private static final int CHAR_HEIGHT = 6;

	private static final int GRAPH_LABEL_CHAR_WIDTH = 16;
	private static final int GRAPH_LABEL_CHAR_HEIGHT = 16;

	/*******************************************
	 * Instance Variables
	 *******************************************/

	private int margin = 50;

	List graphDataList = new ArrayList();
	int agentNumMax;
	int relationNumMax;
	int graphWidth = 0;
	int graphHeight = 0;

	/*******************************************
	 * Constructors
	 *******************************************/

	/**
	 * Constructor for CircleRelationViewCanvas.
	 * @param agentTypes
	 * @param relationTypes
	 */
	public CollaborationGraphCanvas(
		TypeSelection agentTypes,
		TypeSelection relationTypes) {
		super(agentTypes, relationTypes);
	}

	/*******************************************
	 * layouting
	 *******************************************/

	/**
	 * re-layout all nodes
	 * re-layout circle
	 */
	protected void layoutNodes() {

		updateGraphData();

		//\ЂǂƂĂ܂BOtr[Ȃ̂ŁAxׂĂAgentNode폜
		removeAllAgentNodes(new ArrayList(super.getOrderedAllNodes()));

	}

	/**
	 * uꂼ̃NG[WFg𐔂邽߂̃f[^XV
	 */
	private void updateGraphData() {

		graphDataList.clear();

		List nodes = new ArrayList(super.getOrderedAllNodes());
		agentNumMax = nodes.size();
		
		
		Iterator i = nodes.iterator();
		int agentCount = -1;			
		while (i.hasNext()) {
			agentCount++;
			int relationNum = 0;

			//Ή郊N𐔂B
			Agent agent = (Agent) (((AgentNode) i.next()).getAgent());
			Iterator j =
				((List) getRelationTypeSelection().getSelectedTypes())
					.iterator();
			
			while (j.hasNext()) {
				relationNum
					+= agent.getRelations((RelationType) j.next()).size();
				
				//N̍ől̋L^i\̂߁j
				if (relationNum > relationNumMax) {
					relationNumMax = relationNum;
				}
			}
			graphDataList.add(new Integer(relationNum));
		}
		agentNumMax = agentCount;
		
		Collections.sort(graphDataList);
		Collections.reverse(graphDataList);
	}


	/**
	 * paintComponent̃I[o[Ch
	 */
	protected void paintComponent(Graphics g) {
		super.paintComponent(g);

		graphWidth = this.getWidth() - margin * 2;
		graphHeight = this.getHeight() - margin * 2;

		//x
		g.drawLine(
			margin,
			this.getHeight() - margin,
			this.getWidth() - margin,
			this.getHeight() - margin);
		//y
		g.drawLine(margin, margin, this.margin, this.getHeight() - margin);



			int expXCount = calcurateMax(agentNumMax);
			int expYCount = calcurateMax(relationNumMax);
			
			double xScale = (double)graphWidth / (double)expXCount;
			double yScale = (double)graphHeight / (double)expYCount;

	
			//X
			for(int i=0; i<=expXCount; i++){
				g.setFont(new Font("Helvetica", Font.PLAIN, GRAPH_LABEL_CHAR_WIDTH));
				g.drawString("10",margin+(int)(xScale*i), this.getHeight() - margin +GRAPH_LABEL_CHAR_HEIGHT +3);
				g.setFont(new Font("Helvetica", Font.PLAIN, GRAPH_LABEL_CHAR_WIDTH-4));
				g.drawString(""+i,margin+(int)(xScale*i)+GRAPH_LABEL_CHAR_WIDTH+3, this.getHeight() - margin +GRAPH_LABEL_CHAR_HEIGHT /2 +3);
			}	
			
	
			//Y
			for(int i=0; i<=expYCount; i++){
				g.setFont(new Font("Helvetica", Font.PLAIN, GRAPH_LABEL_CHAR_WIDTH));
				g.drawString("10",margin - GRAPH_LABEL_CHAR_WIDTH*2, this.getHeight() - margin -(int)(yScale*i));
				g.setFont(new Font("Helvetica", Font.PLAIN, GRAPH_LABEL_CHAR_WIDTH-4));
				g.drawString(""+i,margin -GRAPH_LABEL_CHAR_WIDTH+3, this.getHeight() - margin -(int)(yScale*i)-3);
			}	
	
	
	
			//_vbg
			Iterator i =graphDataList.iterator();
			int x=0;
			while (i.hasNext()) {
				x++;
				double y=(double)((Integer)i.next()).intValue();
				
				int plotX = margin + (int)(xScale * Math.log((double) x) / Math.log(10.0) );
				int plotY = this.getHeight() - margin -(int)(yScale * Math.log(y) / Math.log(10.0));
	
				g.fillOval(plotX, plotY, 5, 5);
			}


	}
	
	
	/*
	 * pɁAnꂽl܂10̉ƂwԂB
	 */
	private int calcurateMax(int max){
		int count = 0;
		while (Math.pow(10, (double)count) < max) {
			count++;
			//[vh~
			if(count>10) break;
		}
		return count;
	}

	/**
	 * \ЂǂƂĂ܂BOtr[Ȃ̂ŁAxׂĂAgentNode폜
	 */
	private void removeAllAgentNodes(List nodes) {
		Iterator i = nodes.iterator();
		while (i.hasNext()) {
			removeAgentNode(((AgentNode) i.next()).getAgent());
		}
	}
	
}