/*
 * LayerRelationViewCanvas.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.relationview.canvas;

import java.util.List;

import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.components.relationview.AgentNode;
import org.boxed_economy.components.relationview.TypeSelection;

/**
 * @author macchan
 * @version $Id: LayerRelationViewCanvas.java,v 1.2 2003/06/03 04:55:30 macchan Exp $
 */
public class LayerRelationViewCanvas extends AbstractRelationViewCanvas {

	/*******************************************
	 * Instance Variables
	 *******************************************/

	private int margin = 50;

	/*******************************************
	 * Constructors
	 *******************************************/

	/**
	 * Constructor for CircleRelationViewCanvas.
	 * @param agentTypes
	 * @param relationTypes
	 */
	public LayerRelationViewCanvas(
		TypeSelection agentTypes,
		TypeSelection relationTypes) {
		super(agentTypes, relationTypes);
	}

	/*******************************************
	 * layouting
	 *******************************************/

	/**
	 * re-layout all nodes
	 * re-layout layer
	 */
	protected void layoutNodes() {

		List agentTypes = super.getAgentTypeSelection().getSelectedTypes();

		int width = this.getWidth();
		int height = this.getHeight();

		int vGap = 0;
		int hGap = 0;

		int typeCount = agentTypes.size();
		vGap = (height - margin) / (typeCount + 1);

		for (int i = 0; i < typeCount; i++) {
			AgentType agentType = (AgentType) agentTypes.get(i);
			List nodes = super.getNodes(agentType);

			int nodeCount = nodes.size();
			hGap = (width - margin) / (nodeCount + 1);

			for (int j = 0; j < nodeCount; j++) {
				AgentNode node = (AgentNode) nodes.get(j);
				int x = margin + hGap * j;
				int y = margin + vGap * i;
				node.setLocation(x, y);
			}
		}
	}

}