/*
 * ColorChooseComboBox.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.relationview.setting;

import java.awt.Color;
import java.util.Iterator;
import java.util.List;

import javax.swing.JComboBox;

/**
 * @author macchan
 * @version $Id: ColorChooseComboBox.java,v 1.2 2003/08/14 18:52:36 macchan Exp $
 */
public class ColorChooseComboBox extends JComboBox {

	private List colors = null;
	private Color extraColor = null;

	/************************************
	 * Constructors
	 ************************************/

	/**
	 * Constructor for ColorChooseComboBox.
	 */
	public ColorChooseComboBox(List colors) {
		this.colors = colors;
		initializeComponent();
		initializeItems();
	}

	/************************************
	 * Initializers
	 ************************************/
	
	/**
	 * Method initializeComponent.
	 */
	private void initializeComponent() {
		setBackground(Color.white);
		setRenderer(new ColorListCellRenderer());
	}

	/**
	 * Method initializeItems.
	 */
	private void initializeItems() {
		Iterator i = colors.iterator();
		while (i.hasNext()) {
			Color element = (Color) i.next();
			addItem(element);
		}
	}

	/************************************
	 * setter and getter
	 ************************************/

	/**
	 * Method getSelectedColor.
	 * @return Color
	 */
	public Color getSelectedColor() {
		return (Color) this.getSelectedItem();
	}
	
	/**
	 * Method setSelectedColor.
	 * @param color
	 */
	public void setSelectedColor(Color color) {
		if (!colors.contains(color)) {
			setExtraColor(color);
		}
		setSelectedItem(color);
	}

	/**
	 * Sets the extraColor.
	 * @param extraColor The extraColor to set
	 */
	private void setExtraColor(Color extraColor) {
		if (this.extraColor != null) {
			removeItem(this.extraColor);
		}
		this.extraColor = extraColor;
		if (this.extraColor != null) {
			addItem(this.extraColor);
		}
	}

}
