/*
 * ColorListCellRenderer.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.relationview.setting;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

/**
 * @author macchan
 * @version $Id: ColorListCellRenderer.java,v 1.1 2003/06/03 04:49:22 macchan Exp $
 */
public class ColorListCellRenderer extends JPanel implements ListCellRenderer {

	/*****************************************
	 * Constants
	 ******************************************/

	private static final Dimension DEFAULT_SIZE = new Dimension(40, 15);
	private static final Dimension DEFAULT_COLOR_RECT_SIZE =
		new Dimension(30, 10);

	/*****************************************
	 * Instance Variable
	 ******************************************/

	private Dimension rectSize = DEFAULT_COLOR_RECT_SIZE;
	private Color color = null;

	/*****************************************
	 * Constructors
	 ******************************************/

	/**
	 * Constructor for ColorListCellRenderer.
	 */
	public ColorListCellRenderer() {
		setPreferredSize(DEFAULT_SIZE);
	}

	/*****************************************
	 * Implementor for ListCellRenderer
	 ******************************************/

	/**
	 * @see javax.swing.ListCellRenderer#getListCellRendererComponent(JList, Object, int, boolean, boolean)
	 */
	public Component getListCellRendererComponent(
		JList list,
		Object value,
		int index,
		boolean isSelected,
		boolean cellHasFocus) {

		if (isSelected) {
			setBackground(list.getSelectionBackground());
			setForeground(list.getSelectionForeground());
		}
		else {
			setBackground(list.getBackground());
			setForeground(list.getForeground());
		}

		this.color = (Color) value;

		return this;
	}

	/*****************************************
	 * Paint
	 ******************************************/

	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		g.setColor(color);
		int x = getWidth() / 2 - rectSize.width / 2;
		int y = getHeight() / 2 - rectSize.height / 2;
		g.fillRect(x, y, rectSize.width, rectSize.height);
	}

	/*****************************************
	 * Overridden for performance reasons.
	 ******************************************/

	/**
	 * Overridden for performance reasons.
	 * See the <a href="#override">Implementation Note</a>
	 * for more information.
	 */
	public void validate() {
	}

	/**
	 * Overridden for performance reasons.
	 * See the <a href="#override">Implementation Note</a>
	 * for more information.
	 */
	public void revalidate() {
	}

	/**
	 * Overridden for performance reasons.
	 * See the <a href="#override">Implementation Note</a>
	 * for more information.
	 */
	public void repaint(long tm, int x, int y, int width, int height) {
	}

	/**
	 * Overridden for performance reasons.
	 * See the <a href="#override">Implementation Note</a>
	 * for more information.
	 */
	public void repaint(Rectangle r) {
	}

}
