/*
 * InstantColorChooser.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.relationview.setting;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.WindowConstants;

import org.boxed_economy.components.elementchooser.VerticalLayoutPanel;

/**
 * @author macchan
 * @version $Id: InstantColorChooser.java,v 1.2 2003/08/14 18:52:36 macchan Exp $
 */
public class InstantColorChooser extends JPanel {

	/************************************
	 * static constants
	 ************************************/

	private static final String CHOOSE_BUTTON_TEXT = "other";
	private static final List DEFAULT_COLOR_LIST = new ArrayList();
	static {
		DEFAULT_COLOR_LIST.add(Color.black);
		DEFAULT_COLOR_LIST.add(Color.red);
		DEFAULT_COLOR_LIST.add(Color.blue);
		DEFAULT_COLOR_LIST.add(Color.yellow);
		DEFAULT_COLOR_LIST.add(Color.green);
	}
	private static final JColorChooser chooser = new JColorChooser();

	/************************************
	 * Instance Variables
	 ************************************/

	private ColorChooseComboBox combobox =
		new ColorChooseComboBox(DEFAULT_COLOR_LIST);

	/**********************************
	 * Constructors
	 **********************************/

	/**
	 * Constructor for InstantColorChooser.
	 */
	public InstantColorChooser() {
		this(Color.black);
	}

	/**
	 * Constructor for InstantColorChooser.
	 */
	public InstantColorChooser(Color initialSelectedColor) {
		setSelectedColor(initialSelectedColor);
		initialize();
	}

	/**********************************
	 * Initializers
	 **********************************/

	/**
	 * Method initialize.
	 */
	private void initialize() {
		//initialize sub components
		JButton chooserButton = new JButton(CHOOSE_BUTTON_TEXT);
		chooserButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				choose();
			}
		});
		chooserButton.setMargin(new Insets(0, 5, 0, 5));

		//add
		add(combobox);
		add(chooserButton);
	}

	/**********************************
	 * getters & setters
	 **********************************/

	/**
	 * Method getSelectedColor.
	 * @return Color
	 */
	public Color getSelectedColor() {
		return combobox.getSelectedColor();
	}

	/**
	 * Method setSelectedColor.
	 * @param color
	 */
	public void setSelectedColor(Color color) {
		combobox.setSelectedColor(color);
	}

	/**********************************
	 * Event Handlers
	 **********************************/

	/**
	 * choose by colorChooser
	 */
	private void choose() {
		Color color =
			chooser.showDialog(this, "ColorChooser", combobox.getSelectedColor());
		if (color != null) {
			setSelectedColor(color);
		}
	}

	/**************************************
	 * test code
	 **************************************/

	public static void main(String args[]) {
		JFrame frame = new JFrame();
		frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		frame.setSize(300, 300);

		JPanel listPanel = new VerticalLayoutPanel();
		listPanel.add(new InstantColorChooser(Color.red));
		listPanel.add(new InstantColorChooser(Color.blue));
		listPanel.add(new InstantColorChooser(Color.lightGray));
		frame.getContentPane().add(listPanel);
		frame.show();
	}
}
