/*
 * TypeColorSettingPanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.relationview.setting;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.WindowConstants;

/**
 * @author macchan
 * @version $Id: TypeColorSettingPanel.java,v 1.2 2003/08/14 18:52:36 macchan Exp $
 */
public class TypeColorSettingPanel extends JPanel {

	private Map types = null;

	private JPanel tablePanel = new JPanel();

	/**
	 * Constructor for TypeColorSettingPanel.
	 */
	public TypeColorSettingPanel(Map types) {
		this.types = types;
		this.initialize();
	}

	/**************************************
	 * Initializer
	 **************************************/

	private void initialize() {
		initializeComponent();
		initializeTitle();
		initializeRecords();
	}

	private void initializeComponent() {
		//initialize layout
		this.setLayout(new BorderLayout());

		//create components
		JScrollPane scroll = new JScrollPane();

		//initialize components
		tablePanel.setBackground(Color.white);
		//tablePanel.setLayout(new GridLayout(0, 3));

		//add components
		scroll.getViewport().add(tablePanel);
		this.add(scroll, BorderLayout.CENTER);
	}

	private void initializeTitle() {
		tablePanel.add(new JLabel("aaaaaaaaaaaaaaaa"));
		tablePanel.add(new JLabel("bbbbbbbbbbbbbbbb"));
		tablePanel.add(new JLabel("cccccccccccccccc"));
	}

	private void initializeRecords() {
		Iterator i = types.keySet().iterator();
		while (i.hasNext()) {
			Object element = i.next();
			initializeRecord(element);
		}
	}

	private void initializeRecord(Object element) {
		TypeColorModel model = (TypeColorModel) types.get(element);

		tablePanel.add(new JLabel(element.toString()));
		//tablePanel.add(new ColorChooseComboBox());
		JPanel panel = new JPanel();
		panel.setBackground(Color.white);
		panel.setLayout(new FlowLayout(FlowLayout.CENTER));
		panel.add(new AButton("choose"));
		tablePanel.add(panel);
	}

	class AButton extends JButton {
		AButton(String text) {
			super(text);
			addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					JColorChooser chooser = new JColorChooser();
					chooser.showDialog(null, "hoge", null);
				}
			});
		}
	}

	/**************************************
	 * test code
	 **************************************/
	public static void main(String args[]) {
		JFrame frame = new JFrame();
		frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		frame.setSize(300, 300);

		Map map = new LinkedHashMap();
		map.put(new Object(), new TypeViewSettingModel());
		TypeColorSettingPanel listPanel = new TypeColorSettingPanel(map);
		frame.getContentPane().add(listPanel);
		frame.show();
	}

}
