/*
 * AgentTypeViewSettingModel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.relationview.setting;

import java.awt.Color;

/**
 * @author macchan
 * @version $Id: TypeViewSettingModel.java,v 1.1 2003/06/03 04:49:22 macchan Exp $
 */
public class TypeViewSettingModel implements TypeColorModel {

	/**************************************
	 * Constants
	 **************************************/

	private static final Color DEFAULT_COLOR = Color.black;

	/**************************************
	 * Instance Variables
	 **************************************/

	private Color color = DEFAULT_COLOR;
	private boolean showLabel = true;

	/**************************************
	 * Constructors
	 **************************************/

	/**
	 * Constructor for AgentTypeViewSettingModel.
	 */
	public TypeViewSettingModel() {
		super();
	}

	/**************************************
	 * Getter and Setter
	 **************************************/

	/**
	 * Returns the color.
	 * @return Color
	 */
	public Color getColor() {
		return color;
	}

	/**
	 * Returns the showLabel.
	 * @return boolean
	 */
	public boolean isShowLabel() {
		return showLabel;
	}

	/**
	 * Sets the color.
	 * @param color The color to set
	 */
	public void setColor(Color color) {
		this.color = color;
	}

	/**
	 * Sets the showLabel.
	 * @param showLabel The showLabel to set
	 */
	public void setShowLabel(boolean showLabel) {
		this.showLabel = showLabel;
	}

}
