/*
 * ViewSettingModel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.relationview.setting;

/**
 * @author macchan
 * @version $Id: ViewSettingModel.java,v 1.1 2003/06/03 04:49:22 macchan Exp $
 */
public class ViewSettingModel {

	/*****************************
	 * static constants
	 *****************************/
	private static final int MONO = 100;
	private static final int COLOR = 101;

	private static final int NORMAL = 201;
	private static final int ARROW = 202;

	/*****************************
	 * attributes
	 *****************************/
	private int agentColor = COLOR;
	private boolean showAgentName = true;

	private int relationLineStyle = NORMAL;
	private int relationColor = COLOR;
	private boolean showRelationName = false;

	/**
	 * Constructor for ViewSettingModel.
	 */
	public ViewSettingModel() {
		super();
	}

	/**
	 * Returns the agentColor.
	 * @return int
	 */
	public int getAgentColor() {
		return agentColor;
	}

	/**
	 * Returns the relationColor.
	 * @return int
	 */
	public int getRelationColor() {
		return relationColor;
	}

	/**
	 * Returns the relationLineStyle.
	 * @return int
	 */
	public int getRelationLineStyle() {
		return relationLineStyle;
	}

	/**
	 * Returns the showAgentName.
	 * @return boolean
	 */
	public boolean isShowAgentName() {
		return showAgentName;
	}

	/**
	 * Returns the showRelationName.
	 * @return boolean
	 */
	public boolean isShowRelationName() {
		return showRelationName;
	}

	/**
	 * Sets the agentColor.
	 * @param agentColor The agentColor to set
	 */
	public void setAgentColor(int agentColor) {
		this.agentColor = agentColor;
	}

	/**
	 * Sets the relationColor.
	 * @param relationColor The relationColor to set
	 */
	public void setRelationColor(int relationColor) {
		this.relationColor = relationColor;
	}

	/**
	 * Sets the relationLineStyle.
	 * @param relationLineStyle The relationLineStyle to set
	 */
	public void setRelationLineStyle(int relationLineStyle) {
		this.relationLineStyle = relationLineStyle;
	}

	/**
	 * Sets the showAgentName.
	 * @param showAgentName The showAgentName to set
	 */
	public void setShowAgentName(boolean showAgentName) {
		this.showAgentName = showAgentName;
	}

	/**
	 * Sets the showRelationName.
	 * @param showRelationName The showRelationName to set
	 */
	public void setShowRelationName(boolean showRelationName) {
		this.showRelationName = showRelationName;
	}

}
