/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.queuetheory.model;

import java.util.Collection;
import java.util.Iterator;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Clock;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.components.stepclock.StepClock;
import org.boxed_economy.queuetheory.model.PoissonRandomNumberGenerator;
import org.boxed_economy.queuetheory.model.QueueTheoryModel;
import org.boxed_economy.queuetheory.model.information.BoardingTicketInformation;
import org.boxed_economy.queuetheory.model.information.PassengerQueueInformation;
import org.boxed_economy.queuetheory.model.presentation.AirportQueueDataGetter;

public class AirportWorld
extends World {
    public int NUMBER_InformationDesk = 1;
    public int NUMBER_CheckInCounter_EconomyClass = 4;
    public int NUMBER_CheckInCounter_BusinessClass = 2;
    public int NUMBER_CheckInCounter_FirstClass = 1;
    public int NUMBER_SecurityCheck = 1;
    public double AVERAGE_ArrivalTime = 1.5;
    public double AVERAGE_InfomationDeskServiceTime = 1.0;
    public int SERVICETIME_CounterWithLuggage_MIN = 5;
    public int SERVICETIME_CounterWithLuggage_MAX = 20;
    public int SERVICETIME_CounterNoLuggage_MIN = 2;
    public int SERVICETIME_CounterNoLuggage_MAX = 4;
    public int SERVICETIME_SecurityCheck_MIN = 1;
    public int SERVICETIME_SecurityCheck_MAX = 2;
    public int TRAVELTIME_FromInfoDeskToCounter_MIN = 5;
    public int TRAVELTIME_FromInfoDeskToCounter_MAX = 8;
    public int TRAVELTIME_FromCounterToSecurityCheck_MIN = 10;
    public int TRAVELTIME_FromCounterToSecurityCheck_MAX = 20;
    public double RATIO_FirstClassPassenger = 0.1;
    public double RATIO_BusinessClassPassenger = 0.3;
    public double RATIO_LuggageFirstClass = 0.7;
    public double RATIO_LuggageBusinessClass = 0.3;
    public double RATIO_LuggageEconomyClass = 0.7;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-model";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.queuetheory.model.AirportWorld");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        BESP.main((String[])stringArray);
    }

    public void initializeWorld() {
        super.initializeWorld();
        this.setClock((Clock)new StepClock());
        this.installRandomNumberGenerator(new PoissonRandomNumberGenerator("PoissonRandomNumberGenerator", 0L));
    }

    public void initializeAgents() {
        super.initializeAgents();
        Agent queueManagerForInformationDesk = this.createQueueManager();
        Agent queueManagerForCheckInCounter_EconomyClass = this.createQueueManager();
        queueManagerForCheckInCounter_EconomyClass.putInformation((Information)new BoardingTicketInformation("Economy class"));
        Agent queueManagerForCheckInCounter_BussinessClass = this.createQueueManager();
        queueManagerForCheckInCounter_BussinessClass.putInformation((Information)new BoardingTicketInformation("Bussiness class"));
        Agent queueManagerForCheckInCounter_FirstClass = this.createQueueManager();
        queueManagerForCheckInCounter_FirstClass.putInformation((Information)new BoardingTicketInformation("First class"));
        Agent queueManagerForGate = this.createQueueManager();
        Agent sink = this.createSink();
        Agent bus = this.createSourceAndAddRelation();
        this.addRelationToSource(bus, queueManagerForInformationDesk);
        int i = 0;
        while (i < this.NUMBER_InformationDesk) {
            Agent informationDesk = super.createAgent(QueueTheoryModel.AGENTTYPE_InformationDesk);
            informationDesk.addBehavior(QueueTheoryModel.BEHAVIORTYPE_InformationDeskService);
            this.addRelationToServer(informationDesk, queueManagerForInformationDesk, queueManagerForCheckInCounter_EconomyClass);
            this.addRelationToServer(informationDesk, queueManagerForInformationDesk, queueManagerForCheckInCounter_BussinessClass);
            this.addRelationToServer(informationDesk, queueManagerForInformationDesk, queueManagerForCheckInCounter_FirstClass);
            ++i;
        }
        i = 0;
        while (i < this.NUMBER_CheckInCounter_EconomyClass) {
            Agent checkInCounter_EconomyClass = super.createAgent(QueueTheoryModel.AGENTTYPE_Counter_EconomyClass);
            checkInCounter_EconomyClass.addBehavior(QueueTheoryModel.BEHAVIORTYPE_Service);
            this.addRelationToServer(checkInCounter_EconomyClass, queueManagerForCheckInCounter_EconomyClass, queueManagerForGate);
            ++i;
        }
        i = 0;
        while (i < this.NUMBER_CheckInCounter_BusinessClass) {
            Agent checkInCounter_BussinessClass = super.createAgent(QueueTheoryModel.AGENTTYPE_Counter_BussinessClass);
            checkInCounter_BussinessClass.addBehavior(QueueTheoryModel.BEHAVIORTYPE_Service);
            this.addRelationToServer(checkInCounter_BussinessClass, queueManagerForCheckInCounter_BussinessClass, queueManagerForGate);
            ++i;
        }
        i = 0;
        while (i < this.NUMBER_CheckInCounter_FirstClass) {
            Agent checkInCounter_FirstClass = super.createAgent(QueueTheoryModel.AGENTTYPE_Counter_FirstClass);
            checkInCounter_FirstClass.addBehavior(QueueTheoryModel.BEHAVIORTYPE_Service);
            this.addRelationToServer(checkInCounter_FirstClass, queueManagerForCheckInCounter_FirstClass, queueManagerForGate);
            ++i;
        }
        i = 0;
        while (i < this.NUMBER_SecurityCheck) {
            Agent gate = super.createAgent(QueueTheoryModel.AGENTTYPE_Gate);
            gate.addBehavior(QueueTheoryModel.BEHAVIORTYPE_Service);
            this.addRelationToServer(gate, queueManagerForGate, sink);
            ++i;
        }
        AirportQueueDataGetter.printInitialCondition(this);
        Collection c = this.getAgents(QueueTheoryModel.AGENTTYPE_QueueManager);
        Iterator i2 = c.iterator();
        while (i2.hasNext()) {
            Agent qm = (Agent)i2.next();
            qm.getRelation(QueueTheoryModel.RELATIONTYPE_ToServer);
        }
    }

    private void addRelationToServer(Agent server, Agent entryQueueManager, Agent exitQueueManager) {
        server.addRelation(QueueTheoryModel.RELATIONTYPE_ToQueueManager, entryQueueManager);
        server.addRelation(QueueTheoryModel.RELATIONTYPE_Route, exitQueueManager);
        entryQueueManager.addRelation(QueueTheoryModel.RELATIONTYPE_ToServer, server);
    }

    private Agent createQueueManager() {
        Agent queueManagerForInformationDesk = super.createAgent(QueueTheoryModel.AGENTTYPE_QueueManager);
        queueManagerForInformationDesk.addBehavior(QueueTheoryModel.BEHAVIORTYPE_ManageQueue);
        queueManagerForInformationDesk.putInformation((Information)new PassengerQueueInformation());
        return queueManagerForInformationDesk;
    }

    private Agent createSink() {
        Agent sink = super.createAgent(QueueTheoryModel.AGENTTYPE_Sink);
        sink.addBehavior(QueueTheoryModel.BEHAVIORTYPE_ManageQueue);
        sink.putInformation((Information)new PassengerQueueInformation());
        sink.addBehavior(QueueTheoryModel.BEHAVIORTYPE_Depart);
        return sink;
    }

    private Agent createSourceAndAddRelation() {
        Agent bus = super.createAgent(QueueTheoryModel.AGENTTYPE_Source);
        bus.addBehavior(QueueTheoryModel.BEHAVIORTYPE_DropPassengers);
        return bus;
    }

    private void addRelationToSource(Agent source, Agent queueManager) {
        source.addRelation(QueueTheoryModel.RELATIONTYPE_Route, queueManager);
    }

    public String getName() {
        return "AirportQueue";
    }

    public String getSERVICETIME_CounterWithLuggage_MINComment() {
        return "\u8377\u7269\u3092\u3082\u3064\u5ba2\u306b\u5bfe\u3059\u308b\u30ab\u30a6\u30f3\u30bf\u30fc\u306e\u6700\u5c0f\u30b5\u30fc\u30d3\u30b9\u6642\u9593";
    }

    public String getSERVICETIME_CounterWithLuggage_MAXComment() {
        return "\u8377\u7269\u3092\u3082\u3064\u5ba2\u306b\u5bfe\u3059\u308b\u30ab\u30a6\u30f3\u30bf\u30fc\u306e\u6700\u5927\u30b5\u30fc\u30d3\u30b9\u6642\u9593";
    }

    public String getSERVICETIME_CounterNoLuggage_MINComment() {
        return "\u8377\u7269\u306e\u306a\u3044\u5ba2\u306b\u5bfe\u3059\u308b\u30ab\u30a6\u30f3\u30bf\u30fc\u306e\u6700\u5c0f\u30b5\u30fc\u30d3\u30b9\u6642\u9593";
    }

    public String getSERVICETIME_CounterNoLuggage_MAXComment() {
        return "\u8377\u7269\u306e\u306a\u3044\u5ba2\u306b\u5bfe\u3059\u308b\u30ab\u30a6\u30f3\u30bf\u30fc\u306e\u6700\u5927\u30b5\u30fc\u30d3\u30b9\u6642\u9593";
    }

    public String getSERVICETIME_SecurityCheck_MINComment() {
        return "\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u30c1\u30a7\u30c3\u30af\u306b\u304b\u304b\u308b\u6700\u5c0f\u306e\u6642\u9593";
    }

    public String getSERVICETIME_SecurityCheck_MAXComment() {
        return "\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u30c1\u30a7\u30c3\u30af\u306b\u304b\u304b\u308b\u6700\u5927\u306e\u6642\u9593";
    }

    public String getTRAVELTIME_FromInfoDeskToCounter_MINComment() {
        return "\u30a4\u30f3\u30d5\u30a9\u30e1\u30fc\u30b7\u30e7\u30f3\u30c7\u30b9\u30af\u304b\u3089\u30ab\u30a6\u30f3\u30bf\u30fc\u307e\u3067\u306e\u6700\u5c0f\u6b69\u884c\u6642\u9593";
    }

    public String getTRAVELTIME_FromInfoDeskToCounter_MAXComment() {
        return "\u30a4\u30f3\u30d5\u30a9\u30e1\u30fc\u30b7\u30e7\u30f3\u30c7\u30b9\u30af\u304b\u3089\u30ab\u30a6\u30f3\u30bf\u30fc\u307e\u3067\u306e\u6700\u5927\u6b69\u884c\u6642\u9593";
    }

    public String getTRAVELTIME_FromCounterToSecurityCheck_MINComment() {
        return "\u30ab\u30a6\u30f3\u30bf\u30fc\u304b\u3089\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u30c1\u30a7\u30c3\u30af\u307e\u3067\u306e\u6700\u5c0f\u6b69\u884c\u6642\u9593";
    }

    public String getTRAVELTIME_FromCounterToSecurityCheck_MAXComment() {
        return "\u30ab\u30a6\u30f3\u30bf\u30fc\u304b\u3089\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u30c1\u30a7\u30c3\u30af\u307e\u3067\u306e\u6700\u5927\u6b69\u884c\u6642\u9593";
    }

    public String getNUMBER_InformationDeskComment() {
        return "\u30a4\u30f3\u30d5\u30a9\u30e1\u30fc\u30b7\u30e7\u30f3\u30c7\u30b9\u30af\u306e\u6570";
    }

    public String getNUMBER_CheckInCounter_EconomyClassComment() {
        return "\u30a8\u30b3\u30ce\u30df\u30fc\u30af\u30e9\u30b9\u306e\u30ab\u30a6\u30f3\u30bf\u30fc\u306e\u6570";
    }

    public String getNUMBER_CheckInCounter_BusinessClassComment() {
        return "\u30d3\u30b8\u30cd\u30b9\u30af\u30e9\u30b9\u306e\u30ab\u30a6\u30f3\u30bf\u30fc\u306e\u6570";
    }

    public String getNUMBER_CheckInCounter_FirstClassComment() {
        return "\u30d5\u30a1\u30fc\u30b9\u30c8\u30af\u30e9\u30b9\u306e\u30ab\u30a6\u30f3\u30bf\u30fc\u306e\u6570";
    }

    public String getNUMBER_SecurityCheckComment() {
        return "\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u30c1\u30a7\u30c3\u30af\u306e\u6570";
    }

    public String getAVERAGE_ArrivalTimeComment() {
        return "\u4e57\u5ba2\u306e\u5230\u7740\u9593\u9694\uff08\u5206\uff09\u306e\u5e73\u5747\u5024";
    }

    public String getAVERAGE_InfomationDeskServiceTimeComment() {
        return "\u30a4\u30f3\u30d5\u30a9\u30e1\u30fc\u30b7\u30e7\u30f3\u30c7\u30b9\u30af\u306e\u4e57\u5ba2\uff11\u4eba\u3042\u305f\u308a\u30b5\u30fc\u30d3\u30b9\u6642\u9593\u306e\u5e73\u5747\u5024";
    }

    public String getRATIO_FirstClassPassengerComment() {
        return "\u4e57\u5ba2\u304c\u30d5\u30a1\u30fc\u30b9\u30c8\u30af\u30e9\u30b9\u3067\u3042\u308b\u78ba\u7387";
    }

    public String getRATIO_BusinessClassPassengerComment() {
        return "\u4e57\u5ba2\u304c\u30d3\u30b8\u30cd\u30b9\u30af\u30e9\u30b9\u3067\u3042\u308b\u78ba\u7387";
    }

    public String getRATIO_LuggageFirstClassComment() {
        return "\u30d5\u30a1\u30fc\u30b9\u30c8\u30af\u30e9\u30b9\u306e\u4e57\u5ba2\u304c\u624b\u8377\u7269\u3092\u3082\u3063\u3066\u3044\u308b\u78ba\u7387";
    }

    public String getRATIO_LuggageBusinessClassComment() {
        return "\u30d3\u30b8\u30cd\u30b9\u30af\u30e9\u30b9\u306e\u4e57\u5ba2\u304c\u8377\u7269\u3092\u3082\u3063\u3066\u3044\u308b\u78ba\u7387";
    }

    public String getRATIO_LuggageEconomyClassComment() {
        return "\u30a8\u30b3\u30ce\u30df\u30fc\u30af\u30e9\u30b9\u306e\u4e57\u5ba2\u304c\u8377\u7269\u3092\u3082\u3063\u3066\u3044\u308b\u78ba\u7387";
    }

    public int getNUMBER_CheckInCounter_BusinessClass() {
        return this.NUMBER_CheckInCounter_BusinessClass;
    }

    public int getNUMBER_CheckInCounter_EconomyClass() {
        return this.NUMBER_CheckInCounter_EconomyClass;
    }

    public int getNUMBER_CheckInCounter_FirstClass() {
        return this.NUMBER_CheckInCounter_FirstClass;
    }

    public int getNUMBER_SecurityCheck() {
        return this.NUMBER_SecurityCheck;
    }

    public int getNUMBER_InformationDesk() {
        return this.NUMBER_InformationDesk;
    }

    public void setNUMBER_CheckInCounter_BusinessClass(int nUMBER_CheckInCounter_BusinessClass) {
        this.NUMBER_CheckInCounter_BusinessClass = nUMBER_CheckInCounter_BusinessClass;
    }

    public void setNUMBER_CheckInCounter_EconomyClass(int nUMBER_CheckInCounter_EconomyClass) {
        this.NUMBER_CheckInCounter_EconomyClass = nUMBER_CheckInCounter_EconomyClass;
    }

    public void setNUMBER_CheckInCounter_FirstClass(int nUMBER_CheckInCounter_FirstClass) {
        this.NUMBER_CheckInCounter_FirstClass = nUMBER_CheckInCounter_FirstClass;
    }

    public void setNUMBER_SecurityCheck(int nUMBER_Gate) {
        this.NUMBER_SecurityCheck = nUMBER_Gate;
    }

    public void setNUMBER_InformationDesk(int nUMBER_InformationDesk) {
        this.NUMBER_InformationDesk = nUMBER_InformationDesk;
    }

    public double getAVERAGE_ArrivalTime() {
        return this.AVERAGE_ArrivalTime;
    }

    public void setAVERAGE_ArrivalTime(double aVERAGE_ArrivalTime) {
        this.AVERAGE_ArrivalTime = aVERAGE_ArrivalTime;
    }

    public double getAVERAGE_InfomationDeskServiceTime() {
        return this.AVERAGE_InfomationDeskServiceTime;
    }

    public int getSERVICETIME_CounterNoLuggage_MAX() {
        return this.SERVICETIME_CounterNoLuggage_MAX;
    }

    public int getSERVICETIME_CounterWithLuggage_MAX() {
        return this.SERVICETIME_CounterWithLuggage_MAX;
    }

    public int getSERVICETIME_SecurityCheck_MAX() {
        return this.SERVICETIME_SecurityCheck_MAX;
    }

    public int getTRAVELTIME_FromCounterToSecurityCheck_MAX() {
        return this.TRAVELTIME_FromCounterToSecurityCheck_MAX;
    }

    public int getTRAVELTIME_FromInfoDeskToCounter_MAX() {
        return this.TRAVELTIME_FromInfoDeskToCounter_MAX;
    }

    public int getSERVICETIME_CounterNoLuggage_MIN() {
        return this.SERVICETIME_CounterNoLuggage_MIN;
    }

    public int getSERVICETIME_CounterWithLuggage_MIN() {
        return this.SERVICETIME_CounterWithLuggage_MIN;
    }

    public int getSERVICETIME_SecurityCheck_MIN() {
        return this.SERVICETIME_SecurityCheck_MIN;
    }

    public int getTRAVELTIME_FromCounterToSecurityCheck_MIN() {
        return this.TRAVELTIME_FromCounterToSecurityCheck_MIN;
    }

    public int getTRAVELTIME_FromInfoDeskToCounter_MIN() {
        return this.TRAVELTIME_FromInfoDeskToCounter_MIN;
    }

    public void setAVERAGE_InfomationDeskServiceTime(double aVERAGE_InfomationDeskServiceTime) {
        this.AVERAGE_InfomationDeskServiceTime = aVERAGE_InfomationDeskServiceTime;
    }

    public void setSERVICETIME_CounterNoLuggage_MAX(int mAX_CheckInCounterServiceTimeNoLuggage) {
        this.SERVICETIME_CounterNoLuggage_MAX = mAX_CheckInCounterServiceTimeNoLuggage;
    }

    public void setSERVICETIME_CounterWithLuggage_MAX(int mAX_CheckInCounterServiceTimeWithLuggage) {
        this.SERVICETIME_CounterWithLuggage_MAX = mAX_CheckInCounterServiceTimeWithLuggage;
    }

    public void setSERVICETIME_SecurityCheck_MAX(int mAX_SecurityCheckTime) {
        this.SERVICETIME_SecurityCheck_MAX = mAX_SecurityCheckTime;
    }

    public void setTRAVELTIME_FromCounterToSecurityCheck_MAX(int mAX_TravelTimeFromCounterToSecurityCheck) {
        this.TRAVELTIME_FromCounterToSecurityCheck_MAX = mAX_TravelTimeFromCounterToSecurityCheck;
    }

    public void setTRAVELTIME_FromInfoDeskToCounter_MAX(int mAX_TravelTimeFromInfoDeskToCounter) {
        this.TRAVELTIME_FromInfoDeskToCounter_MAX = mAX_TravelTimeFromInfoDeskToCounter;
    }

    public void setSERVICETIME_CounterNoLuggage_MIN(int mIN_CheckInCounterServiceTimeNoLuggage) {
        this.SERVICETIME_CounterNoLuggage_MIN = mIN_CheckInCounterServiceTimeNoLuggage;
    }

    public void setSERVICETIME_CounterWithLuggage_MIN(int mIN_CheckInCounterServiceTimeWithLuggage) {
        this.SERVICETIME_CounterWithLuggage_MIN = mIN_CheckInCounterServiceTimeWithLuggage;
    }

    public void setSERVICETIME_SecurityCheck_MIN(int mIN_SecurityCheckTime) {
        this.SERVICETIME_SecurityCheck_MIN = mIN_SecurityCheckTime;
    }

    public void setTRAVELTIME_FromCounterToSecurityCheck_MIN(int mIN_TravelTimeFromCounterToSecurityCheck) {
        this.TRAVELTIME_FromCounterToSecurityCheck_MIN = mIN_TravelTimeFromCounterToSecurityCheck;
    }

    public void setTRAVELTIME_FromInfoDeskToCounter_MIN(int mIN_TravelTimeFromInfoDeskToCounter) {
        this.TRAVELTIME_FromInfoDeskToCounter_MIN = mIN_TravelTimeFromInfoDeskToCounter;
    }

    public double getRATIO_LuggageBusinessClass() {
        return this.RATIO_LuggageBusinessClass;
    }

    public double getRATIO_BusinessClassPassenger() {
        return this.RATIO_BusinessClassPassenger;
    }

    public double getRATIO_LuggageEconomyClass() {
        return this.RATIO_LuggageEconomyClass;
    }

    public double getRATIO_LuggageFirstClass() {
        return this.RATIO_LuggageFirstClass;
    }

    public double getRATIO_FirstClassPassenger() {
        return this.RATIO_FirstClassPassenger;
    }

    public void setRATIO_LuggageBusinessClass(double rATIO_BusinessClassHasLuggage) {
        this.RATIO_LuggageBusinessClass = rATIO_BusinessClassHasLuggage;
    }

    public void setRATIO_BusinessClassPassenger(double rATIO_BusinessClassPassenger) {
        this.RATIO_BusinessClassPassenger = rATIO_BusinessClassPassenger;
    }

    public void setRATIO_LuggageEconomyClass(double rATIO_EconomyClassHasLuggage) {
        this.RATIO_LuggageEconomyClass = rATIO_EconomyClassHasLuggage;
    }

    public void setRATIO_LuggageFirstClass(double rATIO_FirstClassHasLuggage) {
        this.RATIO_LuggageFirstClass = rATIO_FirstClassHasLuggage;
    }

    public void setRATIO_FirstClassPassenger(double rATIO_FirstClassPassenger) {
        this.RATIO_FirstClassPassenger = rATIO_FirstClassPassenger;
    }
}

