/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.queuetheory.model;

import java.util.Random;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;

public class PoissonRandomNumberGenerator
implements RandomNumberGenerator {
    public static final String NAME = "PoissonRandomNumberGenerator";
    private String name;
    private long seed;
    private Random random;

    public PoissonRandomNumberGenerator(String name, long seed) {
        this.name = name;
        this.seed = seed;
        this.random = new Random(seed);
    }

    public double generatePoisson(double average) {
        return -average * Math.log(this.random.nextDouble());
    }

    public String getName() {
        return this.name;
    }

    public void initialize() {
        this.random = new Random(this.seed);
    }

    public double generate() {
        double value = this.random.nextDouble();
        return value;
    }

    public int generate(int maxValue) {
        double value = this.random.nextDouble();
        int retValue = (int)((double)maxValue * value);
        return retValue;
    }
}

