/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.queuetheory.model.behavior;

import java.util.Collection;
import java.util.Iterator;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.queuetheory.model.AirportWorld;
import org.boxed_economy.queuetheory.model.PoissonRandomNumberGenerator;
import org.boxed_economy.queuetheory.model.QueueTheoryModel;
import org.boxed_economy.queuetheory.model.behavior.AbstractDropPassengersBehavior;
import org.boxed_economy.queuetheory.model.information.BoardingTicketInformation;
import org.boxed_economy.queuetheory.model.information.DebugPrinter;
import org.boxed_economy.queuetheory.model.information.DestinationInformation;

public class DropPassengersBehavior
extends AbstractDropPassengersBehavior {
    private double timeRange = 0.0;

    protected boolean isArrived(Event e) {
        return this.timeRange < 0.0;
    }

    protected boolean isNotArrived(Event e) {
        return 0.0 <= this.timeRange;
    }

    protected void dropPassengersAction() {
        DebugPrinter.println("<IN>-dropPassengersAction : " + this.getAgent().getType());
        DebugPrinter.describe("\u4e57\u5ba2\u3092\u964d\u308d\u3057\u307e\u3059 : " + this.getAgent().getType());
        while (this.timeRange < 0.0) {
            Agent newPassenger = this.createPassenger();
            this.sendDestination(newPassenger);
            this.timeRange += this.getNextPassengerArrivalTime();
        }
        DebugPrinter.println("<OUT>-dropPassengersAction : " + this.getAgent().getType());
    }

    protected void keepDrivingAction() {
        DebugPrinter.println("<IN>-keepDrivingAction : " + this.getAgent().getType());
        this.timeRange -= 1.0;
        DebugPrinter.println("<OUT>-keepDrivingAction : " + this.getAgent().getType());
    }

    private double getNextPassengerArrivalTime() {
        double average = ((AirportWorld)this.getWorld()).getAVERAGE_ArrivalTime();
        PoissonRandomNumberGenerator random = (PoissonRandomNumberGenerator)this.getWorld().getRandomNumberGenerator("PoissonRandomNumberGenerator");
        return random.generatePoisson(average);
    }

    private Agent createPassenger() {
        AirportWorld world = (AirportWorld)this.getWorld();
        Agent newPassenger = this.getAgent().getWorld().createAgent(QueueTheoryModel.AGENTTYPE_Passenger);
        newPassenger.addBehavior(QueueTheoryModel.BEHAVIORTYPE_MoveAndWait);
        RandomNumberGenerator randomNumberGenerator = this.getWorld().getRandomNumberGenerator();
        double random = randomNumberGenerator.generate();
        if (1.0 - world.RATIO_FirstClassPassenger < random) {
            newPassenger.putInformation((Information)new BoardingTicketInformation("First class"));
            this.addLuggage(newPassenger, world.RATIO_LuggageFirstClass);
        } else if (1.0 - world.RATIO_FirstClassPassenger - world.RATIO_BusinessClassPassenger < random) {
            newPassenger.putInformation((Information)new BoardingTicketInformation("Bussiness class"));
            this.addLuggage(newPassenger, world.RATIO_LuggageBusinessClass);
        } else {
            newPassenger.putInformation((Information)new BoardingTicketInformation("Economy class"));
            this.addLuggage(newPassenger, world.RATIO_LuggageEconomyClass);
        }
        return newPassenger;
    }

    private void addLuggage(Agent newPassenger, double ratio) {
        RandomNumberGenerator randomNumberGenerator = this.getWorld().getRandomNumberGenerator();
        if (randomNumberGenerator.generate() < ratio) {
            newPassenger.addGoods(this.getWorld().createGoods(QueueTheoryModel.GOODSTYPE_Luggage, 1.0));
        }
    }

    private void sendDestination(Agent newPassenger) {
        DestinationInformation destination = new DestinationInformation(1);
        Collection toInformationDesks = this.getAgent().getRelations(QueueTheoryModel.RELATIONTYPE_Route);
        Iterator i = toInformationDesks.iterator();
        while (i.hasNext()) {
            Agent informationDesk = ((Relation)i.next()).getTarget();
            destination.addNextQueueManager(informationDesk);
        }
        this.getAgent().addRelation(QueueTheoryModel.RELATIONTYPE_ToServedPassenger, newPassenger);
        this.sendInformation(QueueTheoryModel.RELATIONTYPE_ToServedPassenger, QueueTheoryModel.BEHAVIORTYPE_MoveAndWait, destination);
        this.getAgent().removeRelations(QueueTheoryModel.RELATIONTYPE_ToServedPassenger);
    }

    protected void initialize() {
    }

    protected void terminate() {
    }
}

