/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.queuetheory.model.behavior;

import java.util.Iterator;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Type;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.queuetheory.model.QueueTheoryModel;
import org.boxed_economy.queuetheory.model.behavior.AbstractMoveAndWaitBehavior;
import org.boxed_economy.queuetheory.model.information.DebugPrinter;
import org.boxed_economy.queuetheory.model.information.DestinationInformation;
import org.boxed_economy.queuetheory.model.information.PassengerInformation;

public class MoveAndWaitBehavior
extends AbstractMoveAndWaitBehavior {
    private int slantRange = 0;

    protected boolean isDestinationReceived(Event e) {
        return QueueTheoryModel.INFORMATIONTYPE_Destination.equals((Type)this.getWorld().getInformationType(this.getReceivedInformation()));
    }

    protected void beginMovingAction() {
        int slantRangeToNext;
        DebugPrinter.println("<IN>-beginMovingAction : " + this.getAgent());
        DestinationInformation destination = (DestinationInformation)this.getReceivedInformation();
        Iterator i = destination.Iterator();
        while (i.hasNext()) {
            Agent nextServer = (Agent)i.next();
            this.getAgent().addRelation(QueueTheoryModel.RELATIONTYPE_MoveTo, nextServer);
        }
        this.slantRange = slantRangeToNext = destination.getSlantRange();
        DebugPrinter.describe("\u6b21\u306e\u76ee\u7684\u5730\u3078\u79fb\u52d5\u3092\u958b\u59cb\u3057\u307e\u3059 ... \u6b8b\u308a\u8ddd\u96e2\u306f " + this.slantRange + " : " + this.getAgent());
        DebugPrinter.println("<OUT>-beginMovingAction : " + this.getAgent());
    }

    protected boolean isNotArrivedAtQueue(Event e) {
        return this.slantRange > 0;
    }

    protected void keepMovingAction() {
        DebugPrinter.println("<IN>-keepMovingAction : " + this.getAgent());
        --this.slantRange;
        DebugPrinter.describe("\u6b21\u306e\u76ee\u7684\u5730\u306b\u79fb\u52d5\u4e2d\u3067\u3059 ... \u6b8b\u308a\u8ddd\u96e2\u306f " + this.slantRange + " : " + this.getAgent());
        DebugPrinter.println("<OUT>-keepMovingAction : " + this.getAgent());
    }

    protected boolean isArrivedAtQueue(Event e) {
        return this.slantRange == 0;
    }

    protected void chooseQueueAction() {
        DebugPrinter.println("<IN>-chooseQueueAction : " + this.getAgent());
        Agent queueManager = this.getAgent().getRelation(QueueTheoryModel.RELATIONTYPE_MoveTo).getTarget();
        DebugPrinter.describe("\u5230\u7740\u3057\u305f\u306e\u3067\u5f85\u3061\u884c\u5217\u306b\u4e26\u3073\u307e\u3059 : " + this.getAgent());
        this.sendInformation(QueueTheoryModel.RELATIONTYPE_MoveTo, QueueTheoryModel.BEHAVIORTYPE_ManageQueue, new PassengerInformation(this.getAgent()));
        this.getAgent().removeRelations(QueueTheoryModel.RELATIONTYPE_MoveTo);
        DebugPrinter.println("<OUT>-chooseQueueAction : " + this.getAgent());
    }

    protected boolean isCallFromServerReceived(Event e) {
        return QueueTheoryModel.INFORMATIONTYPE_CallFromServer.equals((Type)this.getWorld().getInformationType(this.getReceivedInformation()));
    }

    protected void serveAction() {
        DebugPrinter.println("<IN>-serveAction : " + this.getAgent());
        DebugPrinter.describe("\u30b5\u30fc\u30d3\u30b9\u3092\u53d7\u3051\u307e\u3059 : " + this.getAgent());
        DebugPrinter.println("<OUT>-serveAction : " + this.getAgent());
    }

    protected void initialize() {
    }

    protected void terminate() {
    }
}

